/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ByteArrayHttpData;
import io.opentelemetry.testing.internal.armeria.common.ByteBufAccessMode;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.internal.common.ByteBufBytes;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.util.ResourceLeakHint;
import java.io.InputStream;
import java.nio.charset.Charset;

final class ByteBufHttpData
extends ByteBufBytes
implements HttpData {
    ByteBufHttpData(ByteBuf buf, boolean pooled) {
        super(buf, pooled);
    }

    @Override
    public HttpData withEndOfStream(boolean endOfStream) {
        if (!endOfStream) {
            return this;
        }
        if (this.isEmpty()) {
            return ByteArrayHttpData.EMPTY_EOS;
        }
        return new EndOfStreamByteBufHttpData(this);
    }

    @Override
    public boolean isEndOfStream() {
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof HttpData)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HttpData that = (HttpData)obj;
        if (this.length() != that.length()) {
            return false;
        }
        return ByteBufUtil.equals(this.buf(), that.byteBuf());
    }

    private static class EndOfStreamByteBufHttpData
    implements HttpData,
    ResourceLeakHint {
        private final ByteBufHttpData delegate;

        EndOfStreamByteBufHttpData(ByteBufHttpData delegate) {
            this.delegate = delegate;
        }

        @Override
        public byte[] array() {
            return this.delegate.array();
        }

        @Override
        public int length() {
            return this.delegate.length();
        }

        @Override
        public String toString(Charset charset) {
            return this.delegate.toString(charset);
        }

        public String toString() {
            return this.delegate + ", {EOS}";
        }

        @Override
        public InputStream toInputStream() {
            return this.delegate.toInputStream();
        }

        @Override
        public boolean isPooled() {
            return this.delegate.isPooled();
        }

        @Override
        public ByteBuf byteBuf(ByteBufAccessMode mode) {
            return this.delegate.byteBuf(mode);
        }

        @Override
        public ByteBuf byteBuf(int offset, int length, ByteBufAccessMode mode) {
            return this.delegate.byteBuf(offset, length, mode);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public HttpData withEndOfStream(boolean endOfStream) {
            if (endOfStream) {
                return this;
            }
            if (this.isEmpty()) {
                return ByteArrayHttpData.EMPTY;
            }
            return this.delegate;
        }

        @Override
        public boolean isEndOfStream() {
            return true;
        }

        @Override
        public String toHintString() {
            return this.delegate.toHintString();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }
    }
}

