/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpMessage;
import io.opentelemetry.testing.internal.armeria.common.DefaultAggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestUtil;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public interface AggregatedHttpRequest
extends AggregatedHttpMessage {
    public static AggregatedHttpRequest of(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return AggregatedHttpRequest.of(RequestHeaders.of(method, path));
    }

    public static AggregatedHttpRequest of(HttpMethod method, String path, MediaType mediaType, CharSequence content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        return AggregatedHttpRequest.of(method, path, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    public static AggregatedHttpRequest of(HttpMethod method, String path, MediaType mediaType, String content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        return AggregatedHttpRequest.of(method, path, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    @FormatMethod
    public static AggregatedHttpRequest of(HttpMethod method, String path, MediaType mediaType, @FormatString String format, Object ... args) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return AggregatedHttpRequest.of(method, path, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), format, args));
    }

    public static AggregatedHttpRequest of(HttpMethod method, String path, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpRequest.of(method, path, mediaType, HttpData.wrap(content));
    }

    public static AggregatedHttpRequest of(HttpMethod method, String path, MediaType mediaType, HttpData content) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpRequest.of(method, path, mediaType, content, HttpHeaders.of());
    }

    public static AggregatedHttpRequest of(HttpMethod method, String path, MediaType mediaType, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        return AggregatedHttpRequest.of(RequestHeaders.builder(method, path).contentType(mediaType).build(), content, trailers);
    }

    public static AggregatedHttpRequest of(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return AggregatedHttpRequest.of(headers, HttpData.empty(), HttpHeaders.of());
    }

    public static AggregatedHttpRequest of(RequestHeaders headers, HttpData content) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpRequest.of(headers, content, HttpHeaders.of());
    }

    public static AggregatedHttpRequest of(RequestHeaders headers, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        return new DefaultAggregatedHttpRequest(HttpRequestUtil.maybeModifyContentLength(headers, content), content, trailers);
    }

    @Override
    public RequestHeaders headers();

    default public URI uri() {
        return this.headers().uri();
    }

    @Nullable
    default public String scheme() {
        return this.headers().scheme();
    }

    default public HttpMethod method() {
        return this.headers().method();
    }

    default public String path() {
        return this.headers().path();
    }

    @Nullable
    default public String authority() {
        return this.headers().authority();
    }

    @Nullable
    default public List<Locale.LanguageRange> acceptLanguages() {
        return this.headers().acceptLanguages();
    }

    @Nullable
    default public Locale selectLocale(Iterable<Locale> supportedLocales) {
        return this.headers().selectLocale(supportedLocales);
    }

    @Nullable
    default public Locale selectLocale(Locale ... supportedLocales) {
        return this.selectLocale(ImmutableList.copyOf(Objects.requireNonNull(supportedLocales, "supportedLocales")));
    }

    default public HttpRequest toHttpRequest() {
        return HttpRequest.of(this.headers(), this.content(), this.trailers());
    }

    default public HttpRequest toHttpRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return HttpRequest.of(headers, this.content(), this.trailers());
    }
}

