/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.RpcClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.retry.AbstractRetryingClient;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfig;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfigMapping;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleWithContent;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryingRpcClientBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.RpcResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientPendingThrowableUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientRequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.StringUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class RetryingRpcClient
extends AbstractRetryingClient<RpcRequest, RpcResponse>
implements RpcClient {
    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryRuleWithContent<RpcResponse> retryRuleWithContent) {
        return RetryingRpcClient.builder(retryRuleWithContent).newDecorator();
    }

    @Deprecated
    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryRuleWithContent<RpcResponse> retryRuleWithContent, int maxTotalAttempts) {
        return RetryingRpcClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).newDecorator();
    }

    @Deprecated
    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryRuleWithContent<RpcResponse> retryRuleWithContent, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return RetryingRpcClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt).newDecorator();
    }

    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryConfig<RpcResponse> retryConfig) {
        return RetryingRpcClient.builder(retryConfig).newDecorator();
    }

    public static Function<? super RpcClient, RetryingRpcClient> newDecorator(RetryConfigMapping<RpcResponse> mapping) {
        return RetryingRpcClient.builder(mapping).newDecorator();
    }

    public static RetryingRpcClientBuilder builder(RetryRuleWithContent<RpcResponse> retryRuleWithContent) {
        return new RetryingRpcClientBuilder(RetryConfig.builder0(retryRuleWithContent).build());
    }

    public static RetryingRpcClientBuilder builder(RetryConfig<RpcResponse> retryConfig) {
        return new RetryingRpcClientBuilder(retryConfig);
    }

    public static RetryingRpcClientBuilder builder(RetryConfigMapping<RpcResponse> mapping) {
        return new RetryingRpcClientBuilder(mapping);
    }

    RetryingRpcClient(RpcClient delegate, RetryConfigMapping<RpcResponse> mapping) {
        super(delegate, mapping, null);
    }

    @Override
    protected RpcResponse doExecute(ClientRequestContext ctx, RpcRequest req) throws Exception {
        CompletableFuture<RpcResponse> future = new CompletableFuture<RpcResponse>();
        RpcResponse res = RpcResponse.from(future);
        this.doExecute0(ctx, req, res, future);
        return res;
    }

    private void doExecute0(ClientRequestContext ctx, RpcRequest req, RpcResponse returnedRes, CompletableFuture<RpcResponse> future) {
        RpcResponse res;
        boolean initialAttempt;
        int totalAttempts = RetryingRpcClient.getTotalAttempts(ctx);
        boolean bl = initialAttempt = totalAttempts <= 1;
        if (returnedRes.isDone()) {
            RetryingRpcClient.handleException(ctx, future, new CancellationException("the response returned to the client has been cancelled"), initialAttempt);
            return;
        }
        if (!this.setResponseTimeout(ctx)) {
            RetryingRpcClient.handleException(ctx, future, ResponseTimeoutException.get(), initialAttempt);
            return;
        }
        ClientRequestContext derivedCtx = RetryingRpcClient.newDerivedContext(ctx, null, req, initialAttempt);
        if (!initialAttempt) {
            derivedCtx.mutateAdditionalRequestHeaders(mutator -> mutator.add((CharSequence)ARMERIA_RETRY_COUNT, StringUtil.toString(totalAttempts - 1)));
        }
        ClientRequestContextExtension ctxExtension = derivedCtx.as(ClientRequestContextExtension.class);
        EndpointGroup endpointGroup = derivedCtx.endpointGroup();
        if (!initialAttempt && ctxExtension != null && endpointGroup != null && derivedCtx.endpoint() == null) {
            ClientPendingThrowableUtil.removePendingThrowable(derivedCtx);
            res = ClientUtil.initContextAndExecuteWithFallback((Client)this.unwrap(), ctxExtension, endpointGroup, RpcResponse::from, (context, cause) -> RpcResponse.ofFailure(cause));
        } else {
            res = ClientUtil.executeWithFallback((Client)this.unwrap(), derivedCtx, (context, cause) -> RpcResponse.ofFailure(cause));
        }
        RetryConfig retryConfig = this.mappedRetryConfig(ctx);
        RetryRuleWithContent retryRule = retryConfig.needsContentInRule() ? retryConfig.retryRuleWithContent() : retryConfig.fromRetryRule();
        res.handle((unused1, cause) -> {
            try {
                retryRule.shouldRetry(derivedCtx, res, (Throwable)cause).handle((decision, unused3) -> {
                    Backoff backoff;
                    Backoff backoff2 = backoff = decision != null ? decision.backoff() : null;
                    if (backoff != null) {
                        long nextDelay = this.getNextDelay(derivedCtx, backoff);
                        if (nextDelay < 0L) {
                            RetryingRpcClient.onRetryComplete(ctx, derivedCtx, res, future);
                            return null;
                        }
                        RetryingRpcClient.scheduleNextRetry(ctx, cause0 -> RetryingRpcClient.handleException(ctx, future, cause0, false), () -> this.doExecute0(ctx, req, returnedRes, future), nextDelay);
                    } else {
                        RetryingRpcClient.onRetryComplete(ctx, derivedCtx, res, future);
                    }
                    return null;
                });
            }
            catch (Throwable t) {
                RetryingRpcClient.handleException(ctx, future, t, false);
            }
            return null;
        });
    }

    private static void onRetryComplete(ClientRequestContext ctx, ClientRequestContext derivedCtx, RpcResponse res, CompletableFuture<RpcResponse> future) {
        RetryingRpcClient.onRetryingComplete(ctx);
        HttpRequest actualHttpReq = derivedCtx.request();
        if (actualHttpReq != null) {
            ctx.updateRequest(actualHttpReq);
        }
        future.complete(res);
    }

    private static void handleException(ClientRequestContext ctx, CompletableFuture<RpcResponse> future, Throwable cause, boolean endRequestLog) {
        future.completeExceptionally(cause);
        if (endRequestLog) {
            ctx.logBuilder().endRequest(cause);
        }
        ctx.logBuilder().endResponse(cause);
    }
}

