/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.AbstractRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryDecision;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRule;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleUtil;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.client.AbstractRuleBuilderUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class RetryRuleBuilder
extends AbstractRuleBuilder {
    RetryRuleBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public RetryRule thenBackoff() {
        return this.thenBackoff(Backoff.ofDefault());
    }

    public RetryRule thenBackoff(Backoff backoff) {
        Objects.requireNonNull(backoff, "backoff");
        return this.build(RetryDecision.retry(backoff));
    }

    public RetryRule thenNoRetry() {
        return this.build(RetryDecision.noRetry());
    }

    private RetryRule build(RetryDecision decision) {
        if (decision != RetryDecision.noRetry() && this.exceptionFilter() == null && this.responseHeadersFilter() == null && this.responseTrailersFilter() == null && this.grpcTrailersFilter() == null) {
            throw new IllegalStateException("Should set at least one retry rule if a backoff was set.");
        }
        BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter = AbstractRuleBuilderUtil.buildFilter(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), false);
        return RetryRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
    }

    static RetryRule build(final BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter, RetryDecision decision, final boolean requiresResponseTrailers) {
        final CompletableFuture<RetryDecision> decisionFuture = decision == RetryDecision.DEFAULT ? RetryRuleUtil.DEFAULT_DECISION : UnmodifiableFuture.completedFuture(decision);
        return new RetryRule(){

            @Override
            public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext ctx, @Nullable Throwable cause) {
                return (Boolean)ruleFilter.apply(ctx, cause) != false ? decisionFuture : RetryRuleUtil.NEXT_DECISION;
            }

            @Override
            public boolean requiresResponseTrailers() {
                return requiresResponseTrailers;
            }
        };
    }

    @Override
    public RetryRuleBuilder onResponseHeaders(BiPredicate<? super ClientRequestContext, ? super ResponseHeaders> responseHeadersFilter) {
        return (RetryRuleBuilder)super.onResponseHeaders(responseHeadersFilter);
    }

    @Override
    public RetryRuleBuilder onResponseTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> responseTrailersFilter) {
        return (RetryRuleBuilder)super.onResponseTrailers(responseTrailersFilter);
    }

    @Override
    public RetryRuleBuilder onGrpcTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> grpcTrailersFilter) {
        return (RetryRuleBuilder)super.onGrpcTrailers(grpcTrailersFilter);
    }

    @Override
    public RetryRuleBuilder onStatusClass(HttpStatusClass ... statusClasses) {
        return (RetryRuleBuilder)super.onStatusClass(statusClasses);
    }

    @Override
    public RetryRuleBuilder onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        return (RetryRuleBuilder)super.onStatusClass(statusClasses);
    }

    @Override
    public RetryRuleBuilder onServerErrorStatus() {
        return (RetryRuleBuilder)super.onServerErrorStatus();
    }

    @Override
    public RetryRuleBuilder onStatus(HttpStatus ... statuses) {
        return (RetryRuleBuilder)super.onStatus(statuses);
    }

    @Override
    public RetryRuleBuilder onStatus(Iterable<HttpStatus> statuses) {
        return (RetryRuleBuilder)super.onStatus(statuses);
    }

    @Override
    public RetryRuleBuilder onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        return (RetryRuleBuilder)super.onStatus(statusFilter);
    }

    @Override
    public RetryRuleBuilder onException(Class<? extends Throwable> exception) {
        return (RetryRuleBuilder)super.onException(exception);
    }

    @Override
    public RetryRuleBuilder onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        return (RetryRuleBuilder)super.onException(exceptionFilter);
    }

    @Override
    public RetryRuleBuilder onException() {
        return (RetryRuleBuilder)super.onException();
    }

    @Override
    public RetryRuleBuilder onTimeoutException() {
        return (RetryRuleBuilder)super.onTimeoutException();
    }

    @Override
    public RetryRuleBuilder onUnprocessed() {
        return (RetryRuleBuilder)super.onUnprocessed();
    }
}

