/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryDecision;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryRuleUtil;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface RetryRule {
    public static RetryRule failsafe() {
        return RetryRule.failsafe(Backoff.ofDefault());
    }

    public static RetryRule failsafe(Backoff backoff) {
        return RetryRule.of(RetryRule.builder(HttpMethod.idempotentMethods()).onServerErrorStatus().onException().thenBackoff(backoff), RetryRule.onUnprocessed(backoff));
    }

    public static RetryRule onStatusClass(HttpStatusClass statusClass) {
        return RetryRule.onStatusClass(statusClass, Backoff.ofDefault());
    }

    public static RetryRule onStatusClass(HttpStatusClass statusClass, Backoff backoff) {
        return RetryRule.builder().onStatusClass(statusClass).thenBackoff(backoff);
    }

    public static RetryRule onStatusClass(HttpStatusClass ... statusClasses) {
        return RetryRule.builder().onStatusClass(statusClasses).thenBackoff();
    }

    public static RetryRule onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        return RetryRule.onStatusClass(statusClasses, Backoff.ofDefault());
    }

    public static RetryRule onStatusClass(Iterable<HttpStatusClass> statusClasses, Backoff backoff) {
        return ((RetryRuleBuilder)RetryRule.builder().onStatusClass((Iterable)statusClasses)).thenBackoff(backoff);
    }

    public static RetryRule onServerErrorStatus() {
        return RetryRule.onServerErrorStatus(Backoff.ofDefault());
    }

    public static RetryRule onServerErrorStatus(Backoff backoff) {
        return RetryRule.builder().onServerErrorStatus().thenBackoff(backoff);
    }

    public static RetryRule onStatus(HttpStatus ... statuses) {
        return RetryRule.builder().onStatus(statuses).thenBackoff();
    }

    public static RetryRule onStatus(Iterable<HttpStatus> statuses) {
        return RetryRule.onStatus(statuses, Backoff.ofDefault());
    }

    public static RetryRule onStatus(Iterable<HttpStatus> statuses, Backoff backoff) {
        return ((RetryRuleBuilder)RetryRule.builder().onStatus((Iterable)statuses)).thenBackoff(backoff);
    }

    public static RetryRule onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        return RetryRule.onStatus(statusFilter, Backoff.ofDefault());
    }

    public static RetryRule onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter, Backoff backoff) {
        return ((RetryRuleBuilder)RetryRule.builder().onStatus((BiPredicate)statusFilter)).thenBackoff(backoff);
    }

    public static RetryRule onException(Class<? extends Throwable> exception) {
        return RetryRule.onException(exception, Backoff.ofDefault());
    }

    public static RetryRule onException(Class<? extends Throwable> exception, Backoff backoff) {
        return ((RetryRuleBuilder)RetryRule.builder().onException((Class)exception)).thenBackoff(backoff);
    }

    public static RetryRule onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        return RetryRule.onException(exceptionFilter, Backoff.ofDefault());
    }

    public static RetryRule onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter, Backoff backoff) {
        return ((RetryRuleBuilder)RetryRule.builder().onException((BiPredicate)exceptionFilter)).thenBackoff(backoff);
    }

    public static RetryRule onException() {
        return RetryRule.onException(Backoff.ofDefault());
    }

    public static RetryRule onException(Backoff backoff) {
        return RetryRule.builder().onException().thenBackoff(backoff);
    }

    @UnstableApi
    public static RetryRule onTimeoutException() {
        return RetryRule.onTimeoutException(Backoff.ofDefault());
    }

    @UnstableApi
    public static RetryRule onTimeoutException(Backoff backoff) {
        return RetryRule.builder().onTimeoutException().thenBackoff(backoff);
    }

    public static RetryRule onUnprocessed() {
        return RetryRule.onUnprocessed(Backoff.ofDefault());
    }

    public static RetryRule onUnprocessed(Backoff backoff) {
        return RetryRule.builder().onUnprocessed().thenBackoff(backoff);
    }

    public static RetryRuleBuilder builder() {
        return RetryRule.builder(HttpMethod.knownMethods());
    }

    public static RetryRuleBuilder builder(HttpMethod ... methods) {
        Objects.requireNonNull(methods, "methods");
        return RetryRule.builder(ImmutableSet.copyOf(methods));
    }

    public static RetryRuleBuilder builder(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        Preconditions.checkArgument(!Iterables.isEmpty(methods), "method can't be empty.");
        ImmutableSet<HttpMethod> httpMethods = Sets.immutableEnumSet(methods);
        return RetryRule.builder((? super ClientRequestContext ctx, ? super RequestHeaders headers) -> httpMethods.contains((Object)headers.method()));
    }

    public static RetryRuleBuilder builder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        return new RetryRuleBuilder(Objects.requireNonNull(requestHeadersFilter, "requestHeadersFilter"));
    }

    public static RetryRule of(RetryRule ... retryRules) {
        Objects.requireNonNull(retryRules, "retryRules");
        Preconditions.checkArgument(retryRules.length > 0, "retryRules can't be empty.");
        if (retryRules.length == 1) {
            return retryRules[0];
        }
        return RetryRule.of(ImmutableList.copyOf(retryRules));
    }

    public static RetryRule of(Iterable<? extends RetryRule> retryRules) {
        Objects.requireNonNull(retryRules, "retryRules");
        Preconditions.checkArgument(!Iterables.isEmpty(retryRules), "retryRules can't be empty.");
        if (Iterables.size(retryRules) == 1) {
            return Iterables.get(retryRules, 0);
        }
        Iterable<? extends RetryRule> cast = retryRules;
        return Streams.stream(cast).reduce(RetryRule::orElse).get();
    }

    default public RetryRule orElse(RetryRule other) {
        return RetryRuleUtil.orElse(this, Objects.requireNonNull(other, "other"));
    }

    public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext var1, @Nullable Throwable var2);

    default public boolean requiresResponseTrailers() {
        return false;
    }
}

