/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfig;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfigMapping;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;

final class KeyedRetryConfigMapping<T extends Response>
implements RetryConfigMapping<T> {
    private final BiFunction<? super ClientRequestContext, Request, RetryConfig<T>> retryConfigFactory;
    private final BiFunction<? super ClientRequestContext, Request, String> keyFactory;
    private final ConcurrentMap<String, RetryConfig<T>> mapping = new ConcurrentHashMap<String, RetryConfig<T>>();

    KeyedRetryConfigMapping(BiFunction<? super ClientRequestContext, Request, String> keyFactory, BiFunction<? super ClientRequestContext, Request, RetryConfig<T>> retryConfigFactory) {
        this.keyFactory = Objects.requireNonNull(keyFactory, "keyFactory");
        this.retryConfigFactory = Objects.requireNonNull(retryConfigFactory, "retryConfigFactory");
    }

    @Override
    public RetryConfig<T> get(ClientRequestContext ctx, Request req) {
        String key = this.keyFactory.apply(ctx, req);
        Objects.requireNonNull(key, "keyFactory.apply() returned null");
        return this.mapping.computeIfAbsent(key, mapKey -> {
            RetryConfig<T> retryConfig = this.retryConfigFactory.apply(ctx, req);
            Objects.requireNonNull(retryConfig, "retryConfigFactory.apply() returned null");
            return retryConfig;
        });
    }
}

