/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.retry.AbstractBackoff;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.ArrayList;

final class ExponentialBackoff
extends AbstractBackoff {
    private final long initialDelayMillis;
    private final long maxDelayMillis;
    private final double multiplier;
    private final long[] precomputedDelays;

    ExponentialBackoff(long initialDelayMillis, long maxDelayMillis, double multiplier) {
        Preconditions.checkArgument(multiplier > 1.0, "multiplier: %s (expected: > 1.0)", (Object)multiplier);
        Preconditions.checkArgument(initialDelayMillis >= 0L, "initialDelayMillis: %s (expected: >= 0)", initialDelayMillis);
        Preconditions.checkArgument(initialDelayMillis <= maxDelayMillis, "maxDelayMillis: %s (expected: >= %s)", maxDelayMillis, initialDelayMillis);
        this.initialDelayMillis = initialDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.multiplier = multiplier;
        ArrayList<Long> precomputed = new ArrayList<Long>();
        for (int i = 1; i <= 30; ++i) {
            long delay = this.computeNextDelayMillis(i);
            if (delay >= maxDelayMillis) {
                precomputed.add(maxDelayMillis);
                break;
            }
            precomputed.add(delay);
        }
        this.precomputedDelays = precomputed.stream().mapToLong(l -> l).toArray();
    }

    @Override
    protected long doNextDelayMillis(int numAttemptsSoFar) {
        if (numAttemptsSoFar == 1) {
            return this.initialDelayMillis;
        }
        int precomputedIndex = numAttemptsSoFar - 1;
        int precomputedLength = this.precomputedDelays.length;
        if (precomputedIndex < precomputedLength) {
            return this.precomputedDelays[precomputedIndex];
        }
        if (this.precomputedDelays[precomputedLength - 1] == this.maxDelayMillis) {
            return this.maxDelayMillis;
        }
        return this.computeNextDelayMillis(numAttemptsSoFar);
    }

    private long computeNextDelayMillis(int numAttemptsSoFar) {
        if (numAttemptsSoFar == 1) {
            return this.initialDelayMillis;
        }
        long nextDelay = ExponentialBackoff.saturatedMultiply(this.initialDelayMillis, Math.pow(this.multiplier, numAttemptsSoFar - 1));
        return Math.min(nextDelay, this.maxDelayMillis);
    }

    private static long saturatedMultiply(long left, double right) {
        double result = (double)left * right;
        return result >= 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("initialDelayMillis", this.initialDelayMillis).add("maxDelayMillis", this.maxDelayMillis).add("multiplier", this.multiplier).toString();
    }
}

