/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.redirect;

import io.opentelemetry.testing.internal.armeria.client.redirect.RedirectsException;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import java.util.Objects;

@UnstableApi
public final class UnexpectedProtocolRedirectException
extends RedirectsException {
    private static final long serialVersionUID = -3766002689876499315L;

    public static UnexpectedProtocolRedirectException of(SessionProtocol redirectProtocol, Iterable<SessionProtocol> expectedProtocols) {
        Objects.requireNonNull(redirectProtocol, "redirectProtocol");
        Objects.requireNonNull(expectedProtocols, "expectedProtocols");
        Preconditions.checkArgument(!Iterables.isEmpty(expectedProtocols), "expectedProtocols can't be empty.");
        return new UnexpectedProtocolRedirectException(redirectProtocol, expectedProtocols);
    }

    private UnexpectedProtocolRedirectException(SessionProtocol redirectProtocol, Iterable<SessionProtocol> expectedProtocols) {
        super("redirectProtocol: " + (Object)((Object)redirectProtocol) + " (expected: " + Iterables.toString(expectedProtocols) + ')');
    }

    @Override
    public Throwable fillInStackTrace() {
        if (Flags.verboseExceptionSampler().isSampled(this.getClass())) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

