/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck;

import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientOptionsBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.AbstractHealthCheckedEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import io.opentelemetry.testing.internal.armeria.client.endpoint.healthcheck.HttpHealthChecker;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthToken;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public final class HealthCheckedEndpointGroupBuilder
extends AbstractHealthCheckedEndpointGroupBuilder {
    private final String path;
    private boolean useGet;

    HealthCheckedEndpointGroupBuilder(EndpointGroup delegate, String path) {
        super(delegate);
        this.path = Objects.requireNonNull(path, "path");
    }

    public HealthCheckedEndpointGroupBuilder useGet(boolean useGet) {
        this.useGet = useGet;
        return this;
    }

    @Override
    public HealthCheckedEndpointGroupBuilder clientFactory(ClientFactory clientFactory) {
        return (HealthCheckedEndpointGroupBuilder)super.clientFactory(clientFactory);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder protocol(SessionProtocol protocol) {
        return (HealthCheckedEndpointGroupBuilder)super.protocol(protocol);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder port(int port) {
        return (HealthCheckedEndpointGroupBuilder)super.port(port);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder retryInterval(Duration retryInterval) {
        return (HealthCheckedEndpointGroupBuilder)super.retryInterval(retryInterval);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder retryIntervalMillis(long retryIntervalMillis) {
        return (HealthCheckedEndpointGroupBuilder)super.retryIntervalMillis(retryIntervalMillis);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder retryBackoff(Backoff retryBackoff) {
        return (HealthCheckedEndpointGroupBuilder)super.retryBackoff(retryBackoff);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder clientOptions(ClientOptions options) {
        return (HealthCheckedEndpointGroupBuilder)super.clientOptions(options);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder withClientOptions(Function<? super ClientOptionsBuilder, ClientOptionsBuilder> configurator) {
        return (HealthCheckedEndpointGroupBuilder)super.withClientOptions(configurator);
    }

    @Override
    protected Function<? super HealthCheckerContext, ? extends AsyncCloseable> newCheckerFactory() {
        return new HttpHealthCheckerFactory(this.path, this.useGet);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder maxEndpointRatio(double maxEndpointRatio) {
        return (HealthCheckedEndpointGroupBuilder)super.maxEndpointRatio(maxEndpointRatio);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder maxEndpointCount(int maxEndpointCount) {
        return (HealthCheckedEndpointGroupBuilder)super.maxEndpointCount(maxEndpointCount);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder auth(AuthToken token) {
        return (HealthCheckedEndpointGroupBuilder)super.auth(token);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        return (HealthCheckedEndpointGroupBuilder)super.allowEmptyEndpoints(allowEmptyEndpoints);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder selectionTimeout(Duration selectionTimeout) {
        return (HealthCheckedEndpointGroupBuilder)super.selectionTimeout(selectionTimeout);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder selectionTimeout(Duration initialSelectionTimeout, Duration selectionTimeout) {
        return (HealthCheckedEndpointGroupBuilder)super.selectionTimeout(initialSelectionTimeout, selectionTimeout);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder selectionTimeoutMillis(long selectionTimeoutMillis) {
        return (HealthCheckedEndpointGroupBuilder)super.selectionTimeoutMillis(selectionTimeoutMillis);
    }

    @Override
    public HealthCheckedEndpointGroupBuilder selectionTimeoutMillis(long initialSelectionTimeoutMillis, long selectionTimeoutMillis) {
        return (HealthCheckedEndpointGroupBuilder)super.selectionTimeoutMillis(initialSelectionTimeoutMillis, selectionTimeoutMillis);
    }

    private static class HttpHealthCheckerFactory
    implements Function<HealthCheckerContext, AsyncCloseable> {
        private final String path;
        private final boolean useGet;

        HttpHealthCheckerFactory(String path, boolean useGet) {
            this.path = path;
            this.useGet = useGet;
        }

        @Override
        public AsyncCloseable apply(HealthCheckerContext ctx) {
            HttpHealthChecker checker = new HttpHealthChecker(ctx, this.path, this.useGet);
            checker.start();
            return checker;
        }
    }
}

