/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.dns;

import io.opentelemetry.testing.internal.armeria.client.DnsCache;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsQueryListener;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DefaultDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.resolver.HostsFileEntriesResolver;
import io.opentelemetry.testing.internal.io.netty.resolver.ResolvedAddressTypes;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import java.net.InetSocketAddress;
import java.time.Duration;

public final class DnsAddressEndpointGroupBuilder
extends DnsEndpointGroupBuilder {
    private int port;
    @Nullable
    private ResolvedAddressTypes resolvedAddressTypes;

    DnsAddressEndpointGroupBuilder(String hostname) {
        super(hostname);
    }

    public DnsAddressEndpointGroupBuilder port(int port) {
        Preconditions.checkArgument(port > 0 && port <= 65535, "port: %s (expected: 1...65535)", port);
        this.port = port;
        return this;
    }

    DnsAddressEndpointGroupBuilder resolvedAddressTypes(ResolvedAddressTypes resolvedAddressTypes) {
        this.resolvedAddressTypes = resolvedAddressTypes;
        return this;
    }

    public DnsAddressEndpointGroup build() {
        EventLoop eventLoop = this.getOrAcquireEventLoop();
        DefaultDnsResolver resolver = this.buildResolver(builder -> {
            if (this.resolvedAddressTypes != null) {
                builder.resolvedAddressTypes(this.resolvedAddressTypes);
            }
        }, eventLoop);
        return new DnsAddressEndpointGroup(this.selectionStrategy(), this.shouldAllowEmptyEndpoints(), this.selectionTimeoutMillis(), resolver, eventLoop, this.backoff(), this.minTtl(), this.maxTtl(), this.resolvedAddressTypes, this.hostname(), this.port, this.dnsQueryListeners());
    }

    @Override
    public DnsAddressEndpointGroupBuilder eventLoop(EventLoop eventLoop) {
        return (DnsAddressEndpointGroupBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public DnsAddressEndpointGroupBuilder backoff(Backoff backoff) {
        return (DnsAddressEndpointGroupBuilder)super.backoff(backoff);
    }

    @Override
    public DnsAddressEndpointGroupBuilder selectionStrategy(EndpointSelectionStrategy selectionStrategy) {
        return (DnsAddressEndpointGroupBuilder)super.selectionStrategy(selectionStrategy);
    }

    @Override
    public DnsAddressEndpointGroupBuilder traceEnabled(boolean traceEnabled) {
        return (DnsAddressEndpointGroupBuilder)super.traceEnabled(traceEnabled);
    }

    @Override
    public DnsAddressEndpointGroupBuilder queryTimeout(Duration queryTimeout) {
        return (DnsAddressEndpointGroupBuilder)super.queryTimeout(queryTimeout);
    }

    @Override
    public DnsAddressEndpointGroupBuilder queryTimeoutMillis(long queryTimeoutMillis) {
        return (DnsAddressEndpointGroupBuilder)super.queryTimeoutMillis(queryTimeoutMillis);
    }

    @Override
    public DnsAddressEndpointGroupBuilder queryTimeoutForEachAttempt(Duration queryTimeoutForEachAttempt) {
        return (DnsAddressEndpointGroupBuilder)super.queryTimeoutForEachAttempt(queryTimeoutForEachAttempt);
    }

    @Override
    public DnsAddressEndpointGroupBuilder queryTimeoutMillisForEachAttempt(long queryTimeoutMillisForEachAttempt) {
        return (DnsAddressEndpointGroupBuilder)super.queryTimeoutMillisForEachAttempt(queryTimeoutMillisForEachAttempt);
    }

    @Override
    public DnsAddressEndpointGroupBuilder recursionDesired(boolean recursionDesired) {
        return (DnsAddressEndpointGroupBuilder)super.recursionDesired(recursionDesired);
    }

    @Override
    public DnsAddressEndpointGroupBuilder maxQueriesPerResolve(int maxQueriesPerResolve) {
        return (DnsAddressEndpointGroupBuilder)super.maxQueriesPerResolve(maxQueriesPerResolve);
    }

    @Override
    public DnsAddressEndpointGroupBuilder serverAddresses(InetSocketAddress ... serverAddresses) {
        return (DnsAddressEndpointGroupBuilder)super.serverAddresses(serverAddresses);
    }

    @Override
    public DnsAddressEndpointGroupBuilder serverAddresses(Iterable<InetSocketAddress> serverAddresses) {
        return (DnsAddressEndpointGroupBuilder)super.serverAddresses(serverAddresses);
    }

    @Override
    public DnsAddressEndpointGroupBuilder serverAddressStreamProvider(DnsServerAddressStreamProvider serverAddressStreamProvider) {
        return (DnsAddressEndpointGroupBuilder)super.serverAddressStreamProvider(serverAddressStreamProvider);
    }

    @Override
    public DnsAddressEndpointGroupBuilder dnsServerAddressStreamProvider(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        return (DnsAddressEndpointGroupBuilder)super.dnsServerAddressStreamProvider(dnsServerAddressStreamProvider);
    }

    @Override
    public DnsAddressEndpointGroupBuilder maxPayloadSize(int maxPayloadSize) {
        return (DnsAddressEndpointGroupBuilder)super.maxPayloadSize(maxPayloadSize);
    }

    @Override
    public DnsAddressEndpointGroupBuilder optResourceEnabled(boolean optResourceEnabled) {
        return (DnsAddressEndpointGroupBuilder)super.optResourceEnabled(optResourceEnabled);
    }

    @Override
    public DnsAddressEndpointGroupBuilder hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        return (DnsAddressEndpointGroupBuilder)super.hostsFileEntriesResolver(hostsFileEntriesResolver);
    }

    @Override
    public DnsAddressEndpointGroupBuilder dnsQueryLifecycleObserverFactory(DnsQueryLifecycleObserverFactory observerFactory) {
        return (DnsAddressEndpointGroupBuilder)super.dnsQueryLifecycleObserverFactory(observerFactory);
    }

    @Override
    @Deprecated
    public DnsAddressEndpointGroupBuilder disableDnsQueryMetrics() {
        return (DnsAddressEndpointGroupBuilder)super.disableDnsQueryMetrics();
    }

    @Override
    public DnsAddressEndpointGroupBuilder enableDnsQueryMetrics(boolean enable) {
        return (DnsAddressEndpointGroupBuilder)super.enableDnsQueryMetrics(enable);
    }

    @Override
    public DnsAddressEndpointGroupBuilder searchDomains(String ... searchDomains) {
        return (DnsAddressEndpointGroupBuilder)super.searchDomains(searchDomains);
    }

    @Override
    public DnsAddressEndpointGroupBuilder searchDomains(Iterable<String> searchDomains) {
        return (DnsAddressEndpointGroupBuilder)super.searchDomains(searchDomains);
    }

    @Override
    public DnsAddressEndpointGroupBuilder ndots(int ndots) {
        return (DnsAddressEndpointGroupBuilder)super.ndots(ndots);
    }

    @Override
    public DnsAddressEndpointGroupBuilder decodeIdn(boolean decodeIdn) {
        return (DnsAddressEndpointGroupBuilder)super.decodeIdn(decodeIdn);
    }

    @Override
    public DnsAddressEndpointGroupBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (DnsAddressEndpointGroupBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public DnsAddressEndpointGroupBuilder cacheSpec(String cacheSpec) {
        return (DnsAddressEndpointGroupBuilder)super.cacheSpec(cacheSpec);
    }

    @Override
    public DnsAddressEndpointGroupBuilder ttl(int minTtl, int maxTtl) {
        return (DnsAddressEndpointGroupBuilder)super.ttl(minTtl, maxTtl);
    }

    @Override
    public DnsAddressEndpointGroupBuilder negativeTtl(int negativeTtl) {
        return (DnsAddressEndpointGroupBuilder)super.negativeTtl(negativeTtl);
    }

    @Override
    public DnsAddressEndpointGroupBuilder dnsCache(DnsCache dnsCache) {
        return (DnsAddressEndpointGroupBuilder)super.dnsCache(dnsCache);
    }

    @Override
    public DnsAddressEndpointGroupBuilder allowEmptyEndpoints(boolean allowEmptyEndpoints) {
        return (DnsAddressEndpointGroupBuilder)super.allowEmptyEndpoints(allowEmptyEndpoints);
    }

    @Override
    public DnsAddressEndpointGroupBuilder selectionTimeout(Duration selectionTimeout) {
        return (DnsAddressEndpointGroupBuilder)super.selectionTimeout(selectionTimeout);
    }

    @Override
    public DnsAddressEndpointGroupBuilder selectionTimeoutMillis(long selectionTimeoutMillis) {
        return (DnsAddressEndpointGroupBuilder)super.selectionTimeoutMillis(selectionTimeoutMillis);
    }

    @Override
    public DnsAddressEndpointGroupBuilder addDnsQueryListeners(Iterable<? extends DnsQueryListener> dnsQueryListeners) {
        return (DnsAddressEndpointGroupBuilder)super.addDnsQueryListeners(dnsQueryListeners);
    }

    @Override
    public DnsAddressEndpointGroupBuilder addDnsQueryListeners(DnsQueryListener ... dnsQueryListeners) {
        return (DnsAddressEndpointGroupBuilder)super.addDnsQueryListeners(dnsQueryListeners);
    }
}

