/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint.dns;

import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.dns.DnsQueryListener;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.SystemInfo;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.ByteArrayDnsRecord;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DefaultDnsResolver;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsQuestionWithoutTrailingDot;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecord;
import io.opentelemetry.testing.internal.io.netty.handler.codec.dns.DnsRecordType;
import io.opentelemetry.testing.internal.io.netty.resolver.ResolvedAddressTypes;
import io.opentelemetry.testing.internal.io.netty.util.NetUtil;
import java.util.List;

public final class DnsAddressEndpointGroup
extends DnsEndpointGroup {
    private final String hostname;
    private final int port;

    public static DnsAddressEndpointGroup of(String hostname) {
        return DnsAddressEndpointGroup.builder(hostname).build();
    }

    public static DnsAddressEndpointGroup of(String hostname, int port) {
        return DnsAddressEndpointGroup.builder(hostname).port(port).build();
    }

    public static DnsAddressEndpointGroupBuilder builder(String hostname) {
        return new DnsAddressEndpointGroupBuilder(hostname);
    }

    DnsAddressEndpointGroup(EndpointSelectionStrategy selectionStrategy, boolean allowEmptyEndpoints, long selectionTimeoutMillis, DefaultDnsResolver resolver, EventLoop eventLoop, Backoff backoff, int minTtl, int maxTtl, @Nullable ResolvedAddressTypes resolvedAddressTypes, String hostname, int port, List<DnsQueryListener> dnsQueryListeners) {
        super(selectionStrategy, allowEmptyEndpoints, selectionTimeoutMillis, resolver, eventLoop, DnsAddressEndpointGroup.newQuestions(hostname, resolvedAddressTypes), backoff, minTtl, maxTtl, dnsQueryListeners);
        this.hostname = hostname;
        this.port = port;
        this.start();
    }

    private static List<DnsQuestionWithoutTrailingDot> newQuestions(String hostname, @Nullable ResolvedAddressTypes resolvedAddressTypes) {
        if (resolvedAddressTypes == null) {
            resolvedAddressTypes = SystemInfo.hasIpV6() ? ResolvedAddressTypes.IPV4_PREFERRED : ResolvedAddressTypes.IPV4_ONLY;
        }
        DnsQuestionWithoutTrailingDot ipV4 = DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.A);
        DnsQuestionWithoutTrailingDot ipV6 = DnsQuestionWithoutTrailingDot.of(hostname, DnsRecordType.AAAA);
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return ImmutableList.of(ipV4);
            }
            case IPV6_ONLY: {
                return ImmutableList.of(ipV6);
            }
            case IPV4_PREFERRED: {
                return ImmutableList.of(ipV4, ipV6);
            }
            case IPV6_PREFERRED: {
                return ImmutableList.of(ipV6, ipV4);
            }
        }
        throw new Error();
    }

    @Override
    ImmutableSortedSet<Endpoint> onDnsRecords(List<DnsRecord> records, int ttl) throws Exception {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        boolean hasLoopbackARecords = records.stream().filter(ByteArrayDnsRecord.class::isInstance).map(ByteArrayDnsRecord.class::cast).anyMatch(r -> {
            byte[] content = r.content();
            return r.type() == DnsRecordType.A && content.length > 0 && content[0] == 127;
        });
        for (DnsRecord r2 : records) {
            String ipAddr;
            byte[] addrBytes;
            if (!(r2 instanceof ByteArrayDnsRecord) || (addrBytes = DnsUtil.extractAddressBytes(r2, this.logger(), this.logPrefix())) == null) continue;
            int contentLen = addrBytes.length;
            if (contentLen == 16) {
                if (addrBytes[0] == 0 && addrBytes[1] == 0 && addrBytes[2] == 0 && addrBytes[3] == 0 && addrBytes[4] == 0 && addrBytes[5] == 0 && addrBytes[6] == 0 && addrBytes[7] == 0 && addrBytes[8] == 0 && addrBytes[9] == 0) {
                    if (addrBytes[10] == 0 && addrBytes[11] == 0) {
                        if (addrBytes[12] == 0 && addrBytes[13] == 0 && addrBytes[14] == 0 && addrBytes[15] == 1) {
                            if (hasLoopbackARecords) continue;
                            ipAddr = "::1";
                        } else {
                            ipAddr = NetUtil.bytesToIpAddress(addrBytes, 12, 4);
                        }
                    } else {
                        ipAddr = addrBytes[10] == -1 && addrBytes[11] == -1 ? NetUtil.bytesToIpAddress(addrBytes, 12, 4) : NetUtil.bytesToIpAddress(addrBytes);
                    }
                } else {
                    ipAddr = NetUtil.bytesToIpAddress(addrBytes);
                }
            } else {
                ipAddr = NetUtil.bytesToIpAddress(addrBytes);
            }
            Endpoint endpoint = Endpoint.unsafeCreate(this.hostname, this.port);
            builder.add(endpoint.withIpAddr(ipAddr));
        }
        ImmutableSet endpoints = builder.build();
        this.logDnsResolutionResult(endpoints, ttl);
        return endpoints;
    }
}

