/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.AbstractEndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointWeightTransition;
import io.opentelemetry.testing.internal.armeria.client.endpoint.WeightRampingUpStrategyBuilder;
import io.opentelemetry.testing.internal.armeria.client.endpoint.WeightedRandomDistributionEndpointSelector;
import io.opentelemetry.testing.internal.armeria.common.CommonPools;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.ListenableAsyncCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.Ticker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

final class WeightRampingUpStrategy
implements EndpointSelectionStrategy {
    private static final Ticker defaultTicker = Ticker.systemTicker();
    private static final WeightedRandomDistributionEndpointSelector EMPTY_SELECTOR = new WeightedRandomDistributionEndpointSelector(ImmutableList.of());
    static final WeightRampingUpStrategy INSTANCE = new WeightRampingUpStrategy(WeightRampingUpStrategyBuilder.defaultTransition, () -> CommonPools.workerGroup().next(), 2000L, 10, 500L, defaultTicker);
    private final EndpointWeightTransition weightTransition;
    private final Supplier<EventExecutor> executorSupplier;
    private final long rampingUpIntervalMillis;
    private final int totalSteps;
    private final long rampingUpTaskWindowNanos;
    private final Ticker ticker;

    WeightRampingUpStrategy(EndpointWeightTransition weightTransition, Supplier<EventExecutor> executorSupplier, long rampingUpIntervalMillis, int totalSteps, long rampingUpTaskWindowMillis) {
        this(weightTransition, executorSupplier, rampingUpIntervalMillis, totalSteps, rampingUpTaskWindowMillis, defaultTicker);
    }

    WeightRampingUpStrategy(EndpointWeightTransition weightTransition, Supplier<EventExecutor> executorSupplier, long rampingUpIntervalMillis, int totalSteps, long rampingUpTaskWindowMillis, Ticker ticker) {
        this.weightTransition = Objects.requireNonNull(weightTransition, "weightTransition");
        this.executorSupplier = Objects.requireNonNull(executorSupplier, "executorSupplier");
        Preconditions.checkArgument(rampingUpIntervalMillis > 0L, "rampingUpIntervalMillis: %s (expected: > 0)", rampingUpIntervalMillis);
        this.rampingUpIntervalMillis = rampingUpIntervalMillis;
        Preconditions.checkArgument(totalSteps > 0, "totalSteps: %s (expected: > 0)", totalSteps);
        this.totalSteps = totalSteps;
        Preconditions.checkArgument(rampingUpTaskWindowMillis >= 0L, "rampingUpTaskWindowMillis: %s (expected: > 0)", rampingUpTaskWindowMillis);
        this.rampingUpTaskWindowNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpTaskWindowMillis);
        this.ticker = Objects.requireNonNull(ticker, "ticker");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RampingUpEndpointWeightSelector(endpointGroup, this.executorSupplier.get());
    }

    final class RampingUpEndpointWeightSelector
    extends AbstractEndpointSelector {
        private final EventExecutor executor;
        private volatile WeightedRandomDistributionEndpointSelector endpointSelector;
        private final List<Endpoint> endpointsFinishedRampingUp;
        final Deque<EndpointsRampingUpEntry> endpointsRampingUp;
        @Nullable
        private Set<EndpointsRampingUpEntry.EndpointAndStep> unhandledNewEndpoints;

        RampingUpEndpointWeightSelector(EndpointGroup endpointGroup, EventExecutor executor) {
            super(endpointGroup);
            this.endpointSelector = EMPTY_SELECTOR;
            this.endpointsFinishedRampingUp = new ArrayList<Endpoint>();
            this.endpointsRampingUp = new ArrayDeque<EndpointsRampingUpEntry>();
            this.executor = executor;
            AtomicBoolean initialized = new AtomicBoolean();
            endpointGroup.addListener(newEndpoints -> {
                if (initialized.compareAndSet(false, true)) {
                    ArrayList<Endpoint> dedupEndpoints = new ArrayList<Endpoint>(this.deduplicateEndpoints((List<Endpoint>)newEndpoints).values());
                    this.endpointSelector = new WeightedRandomDistributionEndpointSelector(dedupEndpoints);
                    this.endpointsFinishedRampingUp.addAll(dedupEndpoints);
                } else {
                    executor.execute(() -> this.updateEndpoints((List<Endpoint>)newEndpoints));
                }
            }, true);
            if (endpointGroup instanceof ListenableAsyncCloseable) {
                ((ListenableAsyncCloseable)((Object)endpointGroup)).whenClosed().thenRunAsync(this::close, executor);
            }
        }

        private Map<Endpoint, Endpoint> deduplicateEndpoints(List<Endpoint> newEndpoints) {
            HashMap<Endpoint, Endpoint> newEndpointsMap = new HashMap<Endpoint, Endpoint>(newEndpoints.size());
            newEndpoints.forEach(newEndpoint -> newEndpointsMap.compute((Endpoint)newEndpoint, (key, v) -> v == null ? newEndpoint : newEndpoint.withWeight(newEndpoint.weight() + v.weight())));
            return newEndpointsMap;
        }

        @Override
        public Endpoint selectNow(ClientRequestContext ctx) {
            return this.endpointSelector.selectEndpoint();
        }

        WeightedRandomDistributionEndpointSelector endpointSelector() {
            return this.endpointSelector;
        }

        private void updateEndpoints(List<Endpoint> newEndpoints) {
            this.unhandledNewEndpoints = null;
            Set<EndpointsRampingUpEntry.EndpointAndStep> newlyAddedEndpoints = this.filterOldEndpoints(newEndpoints);
            if (WeightRampingUpStrategy.this.rampingUpTaskWindowNanos > 0L) {
                if (this.shouldRampUpWithPreviousRampedUpEntry()) {
                    if (!newlyAddedEndpoints.isEmpty()) {
                        this.updateWeightAndStep(newlyAddedEndpoints);
                        this.endpointsRampingUp.getLast().addEndpoints(newlyAddedEndpoints);
                    }
                    this.buildEndpointSelector();
                    return;
                }
                if (this.shouldRampUpWithNextScheduledEntry()) {
                    this.unhandledNewEndpoints = newlyAddedEndpoints;
                    return;
                }
            }
            if (newlyAddedEndpoints.isEmpty()) {
                this.buildEndpointSelector();
                return;
            }
            this.updateWeightAndStep(newlyAddedEndpoints);
            if (!newlyAddedEndpoints.isEmpty()) {
                io.opentelemetry.testing.internal.io.netty.util.concurrent.ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(this::updateWeightAndStep, WeightRampingUpStrategy.this.rampingUpIntervalMillis, WeightRampingUpStrategy.this.rampingUpIntervalMillis, TimeUnit.MILLISECONDS);
                EndpointsRampingUpEntry entry = new EndpointsRampingUpEntry(newlyAddedEndpoints, scheduledFuture, WeightRampingUpStrategy.this.ticker, WeightRampingUpStrategy.this.rampingUpIntervalMillis);
                this.endpointsRampingUp.add(entry);
            }
            this.buildEndpointSelector();
        }

        private void buildEndpointSelector() {
            ImmutableList.Builder targetEndpointsBuilder = ImmutableList.builder();
            targetEndpointsBuilder.addAll(this.endpointsFinishedRampingUp);
            for (EndpointsRampingUpEntry entry : this.endpointsRampingUp) {
                for (EndpointsRampingUpEntry.EndpointAndStep endpointAndStep : entry.endpointAndSteps()) {
                    targetEndpointsBuilder.add(endpointAndStep.endpoint().withWeight(endpointAndStep.currentWeight()));
                }
            }
            this.endpointSelector = new WeightedRandomDistributionEndpointSelector((List<Endpoint>)((Object)targetEndpointsBuilder.build()));
        }

        private boolean shouldRampUpWithPreviousRampedUpEntry() {
            EndpointsRampingUpEntry lastEndpointsRampingUpEntry = this.endpointsRampingUp.peekLast();
            return lastEndpointsRampingUpEntry != null && WeightRampingUpStrategy.this.ticker.read() - lastEndpointsRampingUpEntry.lastUpdatedTime <= WeightRampingUpStrategy.this.rampingUpTaskWindowNanos;
        }

        private boolean shouldRampUpWithNextScheduledEntry() {
            EndpointsRampingUpEntry nextEndpointsRampingUpEntry = this.endpointsRampingUp.peek();
            return nextEndpointsRampingUpEntry != null && nextEndpointsRampingUpEntry.nextUpdatingTime - WeightRampingUpStrategy.this.ticker.read() <= WeightRampingUpStrategy.this.rampingUpTaskWindowNanos;
        }

        private Set<EndpointsRampingUpEntry.EndpointAndStep> filterOldEndpoints(List<Endpoint> newEndpoints) {
            Map<Endpoint, Endpoint> newEndpointsMap = this.deduplicateEndpoints(newEndpoints);
            ArrayList<Endpoint> replacedEndpoints = new ArrayList<Endpoint>();
            Iterator<Object> i = this.endpointsFinishedRampingUp.iterator();
            while (i.hasNext()) {
                Endpoint endpointFinishedRampingUp = i.next();
                Endpoint newEndpoint = newEndpointsMap.remove(endpointFinishedRampingUp);
                if (newEndpoint == null) {
                    i.remove();
                    continue;
                }
                if (endpointFinishedRampingUp.weight() > newEndpoint.weight()) {
                    replacedEndpoints.add(newEndpoint);
                    i.remove();
                    continue;
                }
                if (endpointFinishedRampingUp.weight() >= newEndpoint.weight()) continue;
                newEndpointsMap.put(newEndpoint, newEndpoint);
                i.remove();
            }
            if (!replacedEndpoints.isEmpty()) {
                this.endpointsFinishedRampingUp.addAll(replacedEndpoints);
            }
            i = this.endpointsRampingUp.iterator();
            while (i.hasNext()) {
                EndpointsRampingUpEntry endpointsRampingUpEntry = (EndpointsRampingUpEntry)i.next();
                Set<EndpointsRampingUpEntry.EndpointAndStep> endpointAndSteps = endpointsRampingUpEntry.endpointAndSteps();
                this.filterOldEndpoints(endpointAndSteps, newEndpointsMap);
                if (!endpointAndSteps.isEmpty()) continue;
                i.remove();
                endpointsRampingUpEntry.scheduledFuture.cancel(true);
            }
            if (newEndpointsMap.isEmpty()) {
                return ImmutableSet.of();
            }
            HashSet<EndpointsRampingUpEntry.EndpointAndStep> newlyAddedEndpoints = new HashSet<EndpointsRampingUpEntry.EndpointAndStep>(newEndpointsMap.size());
            newEndpointsMap.values().forEach(endpoint -> newlyAddedEndpoints.add(new EndpointsRampingUpEntry.EndpointAndStep((Endpoint)endpoint)));
            return newlyAddedEndpoints;
        }

        private void filterOldEndpoints(Set<EndpointsRampingUpEntry.EndpointAndStep> endpointAndSteps, Map<Endpoint, Endpoint> newEndpointsMap) {
            ArrayList<EndpointsRampingUpEntry.EndpointAndStep> replacedEndpoints = new ArrayList<EndpointsRampingUpEntry.EndpointAndStep>();
            Iterator<EndpointsRampingUpEntry.EndpointAndStep> i = endpointAndSteps.iterator();
            while (i.hasNext()) {
                EndpointsRampingUpEntry.EndpointAndStep endpointAndStep = i.next();
                Endpoint rampingUpEndpoint = endpointAndStep.endpoint();
                Endpoint newEndpoint = newEndpointsMap.remove(rampingUpEndpoint);
                if (newEndpoint == null) {
                    i.remove();
                    continue;
                }
                if (rampingUpEndpoint.weight() == newEndpoint.weight()) continue;
                if (endpointAndStep.currentWeight() > newEndpoint.weight()) {
                    this.endpointsFinishedRampingUp.add(newEndpoint);
                    i.remove();
                    continue;
                }
                int step = endpointAndStep.step();
                EndpointsRampingUpEntry.EndpointAndStep replaced = new EndpointsRampingUpEntry.EndpointAndStep(newEndpoint, step);
                replaced.currentWeight(WeightRampingUpStrategy.this.weightTransition.compute(newEndpoint, step, WeightRampingUpStrategy.this.totalSteps));
                replacedEndpoints.add(replaced);
                i.remove();
            }
            if (!replacedEndpoints.isEmpty()) {
                endpointAndSteps.addAll(replacedEndpoints);
            }
        }

        private void updateWeightAndStep() {
            EndpointsRampingUpEntry entry;
            if (this.unhandledNewEndpoints != null) {
                entry = this.endpointsRampingUp.peek();
                assert (entry != null);
                entry.addEndpoints(this.unhandledNewEndpoints);
                this.unhandledNewEndpoints = null;
            }
            entry = this.endpointsRampingUp.poll();
            assert (entry != null);
            Set<EndpointsRampingUpEntry.EndpointAndStep> endpointAndSteps = entry.endpointAndSteps();
            this.updateWeightAndStep(endpointAndSteps);
            if (endpointAndSteps.isEmpty()) {
                entry.scheduledFuture.cancel(true);
            } else {
                this.endpointsRampingUp.add(entry);
                entry.updateWindowTimestamps();
            }
            this.buildEndpointSelector();
        }

        private void updateWeightAndStep(Set<EndpointsRampingUpEntry.EndpointAndStep> endpointAndSteps) {
            Iterator<EndpointsRampingUpEntry.EndpointAndStep> i = endpointAndSteps.iterator();
            while (i.hasNext()) {
                EndpointsRampingUpEntry.EndpointAndStep endpointAndStep = i.next();
                int step = endpointAndStep.incrementAndGetStep();
                Endpoint endpoint = endpointAndStep.endpoint();
                if (step == WeightRampingUpStrategy.this.totalSteps) {
                    this.endpointsFinishedRampingUp.add(endpoint);
                    i.remove();
                    continue;
                }
                int calculated = WeightRampingUpStrategy.this.weightTransition.compute(endpoint, step, WeightRampingUpStrategy.this.totalSteps);
                int currentWeight = Ints.constrainToRange(calculated, 0, endpoint.weight());
                endpointAndStep.currentWeight(currentWeight);
            }
        }

        private void close() {
            EndpointsRampingUpEntry entry;
            while ((entry = this.endpointsRampingUp.poll()) != null) {
                entry.scheduledFuture.cancel(true);
            }
        }
    }

    static final class EndpointsRampingUpEntry {
        private final Set<EndpointAndStep> endpointAndSteps;
        private final Ticker ticker;
        private final long rampingUpIntervalNanos;
        final ScheduledFuture<?> scheduledFuture;
        long lastUpdatedTime;
        long nextUpdatingTime;

        EndpointsRampingUpEntry(Set<EndpointAndStep> endpointAndSteps, ScheduledFuture<?> scheduledFuture, Ticker ticker, long rampingUpIntervalMillis) {
            this.endpointAndSteps = endpointAndSteps;
            this.scheduledFuture = scheduledFuture;
            this.ticker = ticker;
            this.rampingUpIntervalNanos = TimeUnit.MILLISECONDS.toNanos(rampingUpIntervalMillis);
            this.updateWindowTimestamps();
        }

        Set<EndpointAndStep> endpointAndSteps() {
            return this.endpointAndSteps;
        }

        void addEndpoints(Set<EndpointAndStep> endpoints) {
            this.endpointAndSteps.addAll(endpoints);
        }

        void updateWindowTimestamps() {
            this.lastUpdatedTime = this.ticker.read();
            this.nextUpdatingTime = this.lastUpdatedTime + this.rampingUpIntervalNanos;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("endpointAndSteps", this.endpointAndSteps).add("ticker", this.ticker).add("rampingUpIntervalNanos", this.rampingUpIntervalNanos).add("scheduledFuture", this.scheduledFuture).add("lastUpdatedTime", this.lastUpdatedTime).add("nextUpdatingTime", this.nextUpdatingTime).toString();
        }

        static final class EndpointAndStep {
            private final Endpoint endpoint;
            private int step;
            private int currentWeight;

            EndpointAndStep(Endpoint endpoint) {
                this(endpoint, 0);
            }

            EndpointAndStep(Endpoint endpoint, int step) {
                this.endpoint = endpoint;
                this.step = step;
            }

            int incrementAndGetStep() {
                return ++this.step;
            }

            void currentWeight(int currentWeight) {
                this.currentWeight = currentWeight;
            }

            int currentWeight() {
                return this.currentWeight;
            }

            int step() {
                return this.step;
            }

            Endpoint endpoint() {
                return this.endpoint;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("endpoint", this.endpoint).add("step", this.step).add("currentWeight", this.currentWeight).toString();
            }
        }
    }
}

