/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.AbstractEndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class RoundRobinStrategy
implements EndpointSelectionStrategy {
    static final RoundRobinStrategy INSTANCE = new RoundRobinStrategy();

    private RoundRobinStrategy() {
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new RoundRobinSelector(endpointGroup);
    }

    static class RoundRobinSelector
    extends AbstractEndpointSelector {
        private final AtomicInteger sequence = new AtomicInteger();

        RoundRobinSelector(EndpointGroup endpointGroup) {
            super(endpointGroup);
        }

        @Override
        public Endpoint selectNow(ClientRequestContext ctx) {
            List<Endpoint> endpoints = this.group().endpoints();
            int currentSequence = this.sequence.getAndIncrement();
            if (endpoints.isEmpty()) {
                return null;
            }
            return endpoints.get(Math.abs(currentSequence % endpoints.size()));
        }
    }
}

