/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.AbstractEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseableSupport;
import io.opentelemetry.testing.internal.armeria.common.util.ListenableAsyncCloseable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

final class CompositeEndpointGroup
extends AbstractEndpointGroup
implements ListenableAsyncCloseable {
    private final List<EndpointGroup> endpointGroups;
    private final CompletableFuture<List<Endpoint>> initialEndpointsFuture;
    private final AtomicBoolean dirty;
    private final EndpointSelectionStrategy selectionStrategy;
    private final EndpointSelector selector;
    private final long selectionTimeoutMillis;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);
    private volatile List<Endpoint> merged = ImmutableList.of();

    CompositeEndpointGroup(EndpointSelectionStrategy selectionStrategy, Iterable<EndpointGroup> endpointGroups) {
        this.endpointGroups = ImmutableList.copyOf(Objects.requireNonNull(endpointGroups, "endpointGroups"));
        this.dirty = new AtomicBoolean(true);
        long selectionTimeoutMillis = 0L;
        for (EndpointGroup endpointGroup : endpointGroups) {
            endpointGroup.addListener((Consumer<? super List<Endpoint>>)((Consumer<List>)unused -> {
                this.dirty.set(true);
                this.notifyListeners(this.endpoints());
            }));
            selectionTimeoutMillis = Math.max(selectionTimeoutMillis, endpointGroup.selectionTimeoutMillis());
        }
        this.selectionTimeoutMillis = selectionTimeoutMillis;
        this.initialEndpointsFuture = CompletableFuture.anyOf((CompletableFuture[])this.endpointGroups.stream().map(EndpointGroup::whenReady).toArray(CompletableFuture[]::new)).thenApply(unused -> this.endpoints());
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        this.selector = Objects.requireNonNull(selectionStrategy, "selectionStrategy").newSelector(this);
    }

    @Override
    public List<Endpoint> endpoints() {
        if (!this.dirty.get()) {
            return this.merged;
        }
        if (!this.dirty.compareAndSet(true, false)) {
            return this.merged;
        }
        ImmutableList.Builder newEndpoints = ImmutableList.builder();
        for (EndpointGroup endpointGroup : this.endpointGroups) {
            newEndpoints.addAll(endpointGroup.endpoints());
        }
        this.merged = newEndpoints.build();
        return this.merged;
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        return this.selectionStrategy;
    }

    @Override
    public Endpoint selectNow(ClientRequestContext ctx) {
        return this.selector.selectNow(ctx);
    }

    @Override
    @Deprecated
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.select(ctx, executor);
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
        return this.selector.select(ctx, executor);
    }

    @Override
    public long selectionTimeoutMillis() {
        return this.selectionTimeoutMillis;
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        return this.initialEndpointsFuture;
    }

    @Override
    public boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        CompletableFuture[] closeFutures = (CompletableFuture[])this.endpointGroups.stream().map(AsyncCloseable::closeAsync).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(closeFutures).handle((unused, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
            } else {
                future.complete(null);
            }
            return null;
        });
    }

    @Override
    public void close() {
        this.closeable.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("endpointGroups", this.endpointGroups).toString();
    }
}

