/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientPendingThrowableUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class AbstractEndpointSelector
implements EndpointSelector {
    private final EndpointGroup endpointGroup;

    protected AbstractEndpointSelector(EndpointGroup endpointGroup) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
    }

    protected final EndpointGroup group() {
        return this.endpointGroup;
    }

    @Override
    @Deprecated
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.select(ctx, executor);
    }

    @Override
    public final CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
        Endpoint endpoint = this.selectNow(ctx);
        if (endpoint != null) {
            return UnmodifiableFuture.completedFuture(endpoint);
        }
        ListeningFuture listeningFuture = new ListeningFuture(ctx, executor);
        this.endpointGroup.addListener(listeningFuture);
        endpoint = this.selectNow(ctx);
        if (endpoint != null) {
            this.endpointGroup.removeListener(listeningFuture);
            return UnmodifiableFuture.completedFuture(endpoint);
        }
        long selectionTimeoutMillis = this.endpointGroup.selectionTimeoutMillis();
        if (selectionTimeoutMillis == 0L) {
            return UnmodifiableFuture.completedFuture(null);
        }
        if (selectionTimeoutMillis < Long.MAX_VALUE) {
            ScheduledFuture<?> timeoutFuture = executor.schedule(() -> {
                EndpointSelectionTimeoutException ex = EndpointSelectionTimeoutException.get(this.endpointGroup, selectionTimeoutMillis);
                ClientPendingThrowableUtil.setPendingThrowable(ctx, ex);
                listeningFuture.complete(null);
            }, selectionTimeoutMillis, TimeUnit.MILLISECONDS);
            listeningFuture.timeoutFuture = timeoutFuture;
            if (listeningFuture.isDone()) {
                timeoutFuture.cancel(false);
            }
        }
        return listeningFuture;
    }

    final class ListeningFuture
    extends CompletableFuture<Endpoint>
    implements Consumer<List<Endpoint>> {
        private final ClientRequestContext ctx;
        private final Executor executor;
        @Nullable
        private volatile Endpoint selectedEndpoint;
        @Nullable
        private volatile ScheduledFuture<?> timeoutFuture;

        ListeningFuture(ClientRequestContext ctx, Executor executor) {
            this.ctx = ctx;
            this.executor = executor;
        }

        @Override
        public void accept(List<Endpoint> unused) {
            if (this.selectedEndpoint != null || this.isDone()) {
                return;
            }
            try {
                Endpoint endpoint = AbstractEndpointSelector.this.selectNow(this.ctx);
                if (endpoint != null) {
                    this.cleanup();
                    this.selectedEndpoint = endpoint;
                    this.executor.execute(() -> super.complete(endpoint));
                }
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cleanup();
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean complete(Endpoint value) {
            this.cleanup();
            return super.complete(value);
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            this.cleanup();
            return super.completeExceptionally(ex);
        }

        private void cleanup() {
            AbstractEndpointSelector.this.group().removeListener(this);
            ScheduledFuture<?> timeoutFuture = this.timeoutFuture;
            if (timeoutFuture != null) {
                this.timeoutFuture = null;
                timeoutFuture.cancel(false);
            }
        }

        @Nullable
        ScheduledFuture<?> timeoutFuture() {
            return this.timeoutFuture;
        }
    }
}

