/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.encoding;

import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.encoding.DecodingClient;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoderFactory;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class DecodingClientBuilder {
    private List<StreamDecoderFactory> decoderFactories = ImmutableList.of(StreamDecoderFactory.brotli(), StreamDecoderFactory.gzip(), StreamDecoderFactory.deflate());
    private boolean autoFillAcceptEncoding = true;
    private boolean strictContentEncoding;

    DecodingClientBuilder() {
    }

    public DecodingClientBuilder decoderFactories(StreamDecoderFactory ... decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        return this.decoderFactories(ImmutableList.copyOf(decoderFactories));
    }

    public DecodingClientBuilder decoderFactories(Iterable<? extends StreamDecoderFactory> decoderFactories) {
        Objects.requireNonNull(decoderFactories, "decoderFactories");
        this.decoderFactories = ImmutableList.copyOf(decoderFactories);
        return this;
    }

    public DecodingClientBuilder autoFillAcceptEncoding(boolean autoFillAcceptEncoding) {
        this.autoFillAcceptEncoding = autoFillAcceptEncoding;
        return this;
    }

    public DecodingClientBuilder strictContentEncoding(boolean strict) {
        this.strictContentEncoding = strict;
        return this;
    }

    public Function<? super HttpClient, DecodingClient> newDecorator() {
        return this::build;
    }

    public DecodingClient build(HttpClient delegate) {
        return new DecodingClient(delegate, this.decoderFactories, this.autoFillAcceptEncoding, this.strictContentEncoding);
    }
}

