/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.cookie;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.SimpleDecoratingHttpClient;
import io.opentelemetry.testing.internal.armeria.client.cookie.CookieJar;
import io.opentelemetry.testing.internal.armeria.client.cookie.CookiePolicy;
import io.opentelemetry.testing.internal.armeria.client.cookie.DefaultCookieJar;
import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.Cookies;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class CookieClient
extends SimpleDecoratingHttpClient {
    private final CookieJar cookieJar;

    public static Function<? super HttpClient, CookieClient> newDecorator() {
        return CookieClient.newDecorator(new DefaultCookieJar());
    }

    public static Function<? super HttpClient, CookieClient> newDecorator(CookiePolicy cookiePolicy) {
        Objects.requireNonNull(cookiePolicy, "cookiePolicy");
        return CookieClient.newDecorator(new DefaultCookieJar(cookiePolicy));
    }

    public static Function<? super HttpClient, CookieClient> newDecorator(CookieJar cookieJar) {
        Objects.requireNonNull(cookieJar, "cookieJar");
        return client -> new CookieClient((HttpClient)client, cookieJar);
    }

    private CookieClient(HttpClient delegate, CookieJar cookieJar) {
        super(delegate);
        this.cookieJar = cookieJar;
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        URI uri = ctx.uri();
        Cookies cookies = this.cookieJar.get(uri);
        if (!cookies.isEmpty()) {
            String cookieHeader = Cookie.toCookieHeader(cookies);
            req = req.withHeaders(req.headers().toBuilder().add((CharSequence)HttpHeaderNames.COOKIE, cookieHeader));
            ctx.updateRequest(req);
        }
        return ((HttpResponse)((Client)this.unwrap()).execute(ctx, req)).peekHeaders(headers -> {
            List<String> setCookieHeaders = headers.getAll(HttpHeaderNames.SET_COOKIE);
            if (!setCookieHeaders.isEmpty()) {
                this.cookieJar.set(uri, Cookie.fromSetCookieHeaders(setCookieHeaders));
            }
        });
    }
}

