/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.AbstractRuleWithContentBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerDecision;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRule;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.internal.client.AbstractRuleBuilderUtil;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class CircuitBreakerRuleWithContentBuilder<T extends Response>
extends AbstractRuleWithContentBuilder<T> {
    CircuitBreakerRuleWithContentBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public CircuitBreakerRuleWithContent<T> thenSuccess() {
        return this.build(CircuitBreakerDecision.success());
    }

    public CircuitBreakerRuleWithContent<T> thenFailure() {
        return this.build(CircuitBreakerDecision.failure());
    }

    public CircuitBreakerRuleWithContent<T> thenIgnore() {
        return this.build(CircuitBreakerDecision.ignore());
    }

    private CircuitBreakerRuleWithContent<T> build(CircuitBreakerDecision decision) {
        BiFunction responseFilter = this.responseFilter();
        boolean hasResponseFilter = responseFilter != null;
        BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> ruleFilter = AbstractRuleBuilderUtil.buildFilter(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), hasResponseFilter);
        CircuitBreakerRule first = CircuitBreakerRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
        if (!hasResponseFilter) {
            return CircuitBreakerRuleUtil.fromCircuitBreakerRule(first);
        }
        CircuitBreakerRuleWithContent<Response> second = (ctx, content, cause) -> {
            if (content == null) {
                return CircuitBreakerRuleUtil.NEXT_DECISION;
            }
            return ((CompletionStage)responseFilter.apply(ctx, content)).handle((matched, cause0) -> {
                if (cause0 != null) {
                    return CircuitBreakerDecision.next();
                }
                return matched != false ? decision : CircuitBreakerDecision.next();
            });
        };
        return CircuitBreakerRuleUtil.orElse(first, second);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onResponse(BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> responseFilter) {
        return (CircuitBreakerRuleWithContentBuilder)super.onResponse(responseFilter);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onResponseHeaders(BiPredicate<? super ClientRequestContext, ? super ResponseHeaders> responseHeadersFilter) {
        return (CircuitBreakerRuleWithContentBuilder)super.onResponseHeaders(responseHeadersFilter);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onResponseTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> responseTrailersFilter) {
        return (CircuitBreakerRuleWithContentBuilder)super.onResponseTrailers(responseTrailersFilter);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onGrpcTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> grpcTrailersFilter) {
        return (CircuitBreakerRuleWithContentBuilder)super.onGrpcTrailers(grpcTrailersFilter);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onStatusClass(HttpStatusClass ... statusClasses) {
        return (CircuitBreakerRuleWithContentBuilder)super.onStatusClass(statusClasses);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        return (CircuitBreakerRuleWithContentBuilder)super.onStatusClass(statusClasses);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onServerErrorStatus() {
        return (CircuitBreakerRuleWithContentBuilder)super.onServerErrorStatus();
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onStatus(HttpStatus ... statuses) {
        return (CircuitBreakerRuleWithContentBuilder)super.onStatus(statuses);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onStatus(Iterable<HttpStatus> statuses) {
        return (CircuitBreakerRuleWithContentBuilder)super.onStatus(statuses);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        return (CircuitBreakerRuleWithContentBuilder)super.onStatus(statusFilter);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onException(Class<? extends Throwable> exception) {
        return (CircuitBreakerRuleWithContentBuilder)super.onException(exception);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        return (CircuitBreakerRuleWithContentBuilder)super.onException(exceptionFilter);
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onException() {
        return (CircuitBreakerRuleWithContentBuilder)super.onException();
    }

    @Override
    public CircuitBreakerRuleWithContentBuilder<T> onUnprocessed() {
        return (CircuitBreakerRuleWithContentBuilder)super.onUnprocessed();
    }
}

