/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerDecision;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface CircuitBreakerRule {
    public static CircuitBreakerRule onStatusClass(HttpStatusClass statusClass) {
        return CircuitBreakerRule.builder().onStatusClass(statusClass).thenFailure();
    }

    public static CircuitBreakerRule onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        return ((CircuitBreakerRuleBuilder)CircuitBreakerRule.builder().onStatusClass((Iterable)statusClasses)).thenFailure();
    }

    public static CircuitBreakerRule onServerErrorStatus() {
        return CircuitBreakerRule.builder().onServerErrorStatus().thenFailure();
    }

    public static CircuitBreakerRule onStatus(HttpStatus ... statuses) {
        return CircuitBreakerRule.builder().onStatus(statuses).thenFailure();
    }

    public static CircuitBreakerRule onStatus(Iterable<HttpStatus> statuses) {
        return ((CircuitBreakerRuleBuilder)CircuitBreakerRule.builder().onStatus((Iterable)statuses)).thenFailure();
    }

    public static CircuitBreakerRule onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        return ((CircuitBreakerRuleBuilder)CircuitBreakerRule.builder().onStatus((BiPredicate)statusFilter)).thenFailure();
    }

    public static CircuitBreakerRule onException(Class<? extends Throwable> exception) {
        return ((CircuitBreakerRuleBuilder)CircuitBreakerRule.builder().onException((Class)exception)).thenFailure();
    }

    public static CircuitBreakerRule onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        return ((CircuitBreakerRuleBuilder)CircuitBreakerRule.builder().onException((BiPredicate)exceptionFilter)).thenFailure();
    }

    public static CircuitBreakerRule onException() {
        return CircuitBreakerRule.builder().onException().thenFailure();
    }

    @UnstableApi
    public static CircuitBreakerRule onTimeoutException() {
        return CircuitBreakerRule.builder().onTimeoutException().thenFailure();
    }

    public static CircuitBreakerRuleBuilder builder() {
        return CircuitBreakerRule.builder(HttpMethod.knownMethods());
    }

    public static CircuitBreakerRuleBuilder builder(HttpMethod ... methods) {
        Objects.requireNonNull(methods, "methods");
        return CircuitBreakerRule.builder(ImmutableSet.copyOf(methods));
    }

    public static CircuitBreakerRuleBuilder builder(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        Preconditions.checkArgument(!Iterables.isEmpty(methods), "method can't be empty.");
        ImmutableSet<HttpMethod> httpMethods = Sets.immutableEnumSet(methods);
        return CircuitBreakerRule.builder((? super ClientRequestContext unused, ? super RequestHeaders headers) -> httpMethods.contains((Object)headers.method()));
    }

    public static CircuitBreakerRuleBuilder builder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        return new CircuitBreakerRuleBuilder(Objects.requireNonNull(requestHeadersFilter, "requestHeadersFilter"));
    }

    public static CircuitBreakerRule of(CircuitBreakerRule ... circuitBreakerRules) {
        Objects.requireNonNull(circuitBreakerRules, "circuitBreakerRules");
        Preconditions.checkArgument(circuitBreakerRules.length > 0, "circuitBreakerRules can't be empty.");
        if (circuitBreakerRules.length == 1) {
            return circuitBreakerRules[0];
        }
        return CircuitBreakerRule.of(ImmutableList.copyOf(circuitBreakerRules));
    }

    public static CircuitBreakerRule of(Iterable<? extends CircuitBreakerRule> circuitBreakerRules) {
        Objects.requireNonNull(circuitBreakerRules, "circuitBreakerRules");
        Preconditions.checkArgument(!Iterables.isEmpty(circuitBreakerRules), "circuitBreakerRules can't be empty.");
        if (Iterables.size(circuitBreakerRules) == 1) {
            return Iterables.get(circuitBreakerRules, 0);
        }
        Iterable<? extends CircuitBreakerRule> cast = circuitBreakerRules;
        return Streams.stream(cast).reduce(CircuitBreakerRule::orElse).get();
    }

    default public CircuitBreakerRule orElse(CircuitBreakerRule other) {
        return CircuitBreakerRuleUtil.orElse(this, Objects.requireNonNull(other, "other"));
    }

    public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext var1, @Nullable Throwable var2);

    default public boolean requiresResponseTrailers() {
        return false;
    }
}

