/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreaker;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerMappingBuilder;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.ClientCircuitBreakerGenerator;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.KeyedCircuitBreakerMapping;
import io.opentelemetry.testing.internal.armeria.common.Request;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface CircuitBreakerMapping
extends ClientCircuitBreakerGenerator<CircuitBreaker> {
    public static CircuitBreakerMapping ofDefault() {
        return KeyedCircuitBreakerMapping.hostMapping;
    }

    public static CircuitBreakerMappingBuilder builder() {
        return new CircuitBreakerMappingBuilder();
    }

    public static CircuitBreakerMapping perMethod(Function<String, ? extends CircuitBreaker> factory) {
        Objects.requireNonNull(factory, "factory");
        return CircuitBreakerMapping.builder().perMethod().build((host, method, path) -> (CircuitBreaker)factory.apply(method));
    }

    public static CircuitBreakerMapping perHost(Function<String, ? extends CircuitBreaker> factory) {
        Objects.requireNonNull(factory, "factory");
        return CircuitBreakerMapping.builder().perHost().build((host, method, path) -> (CircuitBreaker)factory.apply(host));
    }

    public static CircuitBreakerMapping perPath(Function<String, ? extends CircuitBreaker> factory) {
        Objects.requireNonNull(factory, "factory");
        return CircuitBreakerMapping.builder().perPath().build((host, method, path) -> (CircuitBreaker)factory.apply(path));
    }

    public static CircuitBreakerMapping perHostAndMethod(BiFunction<String, String, ? extends CircuitBreaker> factory) {
        Objects.requireNonNull(factory, "factory");
        return CircuitBreakerMapping.builder().perHost().perMethod().build((host, method, path) -> (CircuitBreaker)factory.apply(host, method));
    }

    @Override
    public CircuitBreaker get(ClientRequestContext var1, Request var2) throws Exception;
}

