/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ConnectionPoolListener;
import io.opentelemetry.testing.internal.armeria.client.ConnectionPoolMetrics;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.util.AttributeMap;
import java.net.InetSocketAddress;
import java.util.Objects;

final class MetricCollectingConnectionPoolListener
implements ConnectionPoolListener {
    private final ConnectionPoolMetrics connectionPoolMetrics;

    MetricCollectingConnectionPoolListener(MeterRegistry registry, MeterIdPrefix idPrefix) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(idPrefix, "idPrefix");
        this.connectionPoolMetrics = new ConnectionPoolMetrics(registry, idPrefix);
    }

    @Override
    public void connectionOpen(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr, AttributeMap attrs) throws Exception {
        this.connectionPoolMetrics.increaseConnOpened(protocol, remoteAddr, localAddr);
    }

    @Override
    public void connectionClosed(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr, AttributeMap attrs) throws Exception {
        this.connectionPoolMetrics.increaseConnClosed(protocol, remoteAddr, localAddr);
    }
}

