/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractHttpRequestSubscriber;
import io.opentelemetry.testing.internal.armeria.client.AggregatedHttpRequestHandler;
import io.opentelemetry.testing.internal.armeria.client.ClientHttp1ObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientHttp2ObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Http1ClientKeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.client.Http1ResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.Http2ClientConnectionHandler;
import io.opentelemetry.testing.internal.armeria.client.Http2ResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.HttpChannelPool;
import io.opentelemetry.testing.internal.armeria.client.HttpClientFactory;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.SessionProtocolNegotiationException;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.client.WebSocketHttp1ClientChannelHandler;
import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyType;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.ClosedSessionException;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.CancelledSubscriptionException;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.client.HttpSession;
import io.opentelemetry.testing.internal.armeria.internal.client.PooledChannel;
import io.opentelemetry.testing.internal.armeria.internal.common.Http2GoAwayHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.InboundTrafficController;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufUtil;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelDuplexHandler;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Settings;
import io.opentelemetry.testing.internal.io.netty.handler.proxy.ProxyConnectException;
import io.opentelemetry.testing.internal.io.netty.handler.proxy.ProxyConnectionEvent;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslCompletionEvent;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import io.opentelemetry.testing.internal.io.netty.util.ReferenceCountUtil;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpSessionHandler
extends ChannelDuplexHandler
implements HttpSession {
    private static final Logger logger = LoggerFactory.getLogger(HttpSessionHandler.class);
    private static final AttributeKey<Throwable> PENDING_EXCEPTION = AttributeKey.valueOf(HttpSessionHandler.class, "PENDING_EXCEPTION");
    private final HttpChannelPool channelPool;
    private final Channel channel;
    private final SocketAddress remoteAddress;
    private final Promise<Channel> sessionPromise;
    private final ScheduledFuture<?> sessionTimeoutFuture;
    private final SessionProtocol desiredProtocol;
    private final SerializationFormat serializationFormat;
    private final HttpChannelPool.PoolKey poolKey;
    private final HttpClientFactory clientFactory;
    @Nullable
    private SocketAddress proxyDestinationAddress;
    private volatile boolean isAcquirable;
    @Nullable
    private SessionProtocol protocol;
    @Nullable
    private HttpResponseDecoder responseDecoder;
    @Nullable
    private ClientHttpObjectEncoder requestEncoder;
    private int maxUnfinishedResponses = Integer.MAX_VALUE;
    private int numRequestsSent;
    @Nullable
    private SessionProtocol retryProtocol;

    HttpSessionHandler(HttpChannelPool channelPool, Channel channel, Promise<Channel> sessionPromise, ScheduledFuture<?> sessionTimeoutFuture, SessionProtocol desiredProtocol, SerializationFormat serializationFormat, HttpChannelPool.PoolKey poolKey, HttpClientFactory clientFactory) {
        this.channelPool = Objects.requireNonNull(channelPool, "channelPool");
        this.channel = Objects.requireNonNull(channel, "channel");
        this.remoteAddress = channel.remoteAddress();
        this.sessionPromise = Objects.requireNonNull(sessionPromise, "sessionPromise");
        this.sessionTimeoutFuture = Objects.requireNonNull(sessionTimeoutFuture, "sessionTimeoutFuture");
        this.desiredProtocol = desiredProtocol;
        this.serializationFormat = serializationFormat;
        this.poolKey = poolKey;
        this.clientFactory = clientFactory;
    }

    @Override
    public SerializationFormat serializationFormat() {
        return this.serializationFormat;
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public InboundTrafficController inboundTrafficController() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.inboundTrafficController();
    }

    @Override
    public boolean hasUnfinishedResponses() {
        if (this.responseDecoder == null) {
            return false;
        }
        return this.responseDecoder.hasUnfinishedResponses();
    }

    @Override
    public boolean incrementNumUnfinishedResponses() {
        assert (this.responseDecoder != null);
        return this.responseDecoder.reserveUnfinishedResponse(this.maxUnfinishedResponses);
    }

    @Override
    public boolean canSendRequest() {
        assert (this.responseDecoder != null);
        if (!this.channel.isActive()) {
            return false;
        }
        if (this.responseDecoder instanceof Http2ResponseDecoder) {
            Http2GoAwayHandler goAwayHandler = ((Http2ResponseDecoder)this.responseDecoder).goAwayHandler();
            return !goAwayHandler.sentGoAway() && !goAwayHandler.receivedGoAway();
        }
        return this.isAcquirable();
    }

    @Override
    public void invoke(PooledChannel pooledChannel, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        if (this.handleEarlyCancellation(ctx, req, res)) {
            pooledChannel.release();
            return;
        }
        long writeTimeoutMillis = ctx.writeTimeoutMillis();
        assert (this.protocol != null);
        assert (this.responseDecoder != null);
        assert (this.requestEncoder != null);
        if (!this.protocol.isMultiplex() && !this.serializationFormat.requiresNewConnection(this.protocol)) {
            boolean useHttp1Pipelining = this.clientFactory.useHttp1Pipelining();
            CompletableFuture<Void> completionFuture = useHttp1Pipelining ? req.whenComplete() : CompletableFuture.allOf(req.whenComplete(), res.whenComplete());
            completionFuture.handle((ret, cause) -> {
                if (this.isAcquirable()) {
                    pooledChannel.release();
                }
                return null;
            });
        }
        try (SafeCloseable ignored = ctx.push();){
            if (!ctx.exchangeType().isRequestStreaming()) {
                AggregatedHttpRequestHandler reqHandler = new AggregatedHttpRequestHandler(this.channel, this.requestEncoder, this.responseDecoder, req, res, ctx, writeTimeoutMillis);
                req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), this.channel.eventLoop())).handle((BiFunction)reqHandler);
                return;
            }
            AbstractHttpRequestSubscriber subscriber = AbstractHttpRequestSubscriber.of(this.channel, this.requestEncoder, this.responseDecoder, this.protocol, ctx, req, res, writeTimeoutMillis, this.isWebSocket());
            req.subscribe(subscriber, this.channel.eventLoop(), SubscriptionOption.WITH_POOLED_OBJECTS);
        }
    }

    private boolean isWebSocket() {
        return this.serializationFormat == SerializationFormat.WS;
    }

    @Override
    public int incrementAndGetNumRequestsSent() {
        return ++this.numRequestsSent;
    }

    private boolean handleEarlyCancellation(ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res) {
        if (res.isOpen()) {
            return false;
        }
        assert (this.responseDecoder != null);
        this.responseDecoder.decrementUnfinishedResponses();
        assert (this.protocol != null);
        try (SafeCloseable ignored = RequestContextUtil.pop();){
            req.abort(CancelledSubscriptionException.get());
            ctx.logBuilder().session(this.channel, this.protocol, null);
            ctx.logBuilder().requestHeaders(req.headers());
            req.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    ctx.logBuilder().endRequest();
                } else {
                    ctx.logBuilder().endRequest((Throwable)cause);
                }
                return null;
            });
            res.whenComplete().handle((unused, cause) -> {
                if (cause == null) {
                    ctx.logBuilder().endResponse();
                } else {
                    ctx.logBuilder().endResponse((Throwable)cause);
                }
                return null;
            });
        }
        return true;
    }

    @Override
    public void retryWith(SessionProtocol protocol) {
        this.retryProtocol = protocol;
    }

    @Override
    public boolean isAcquirable() {
        if (!this.isAcquirable) {
            return false;
        }
        assert (this.responseDecoder != null);
        KeepAliveHandler keepAliveHandler = this.responseDecoder.keepAliveHandler();
        assert (keepAliveHandler != null);
        return !keepAliveHandler.needsDisconnection();
    }

    @Override
    public void deactivate() {
        if (this.isAcquirable) {
            this.isAcquirable = false;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = this.channel.isActive();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = true;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2Settings) {
            Long maxConcurrentStreams = ((Http2Settings)msg).maxConcurrentStreams();
            this.maxUnfinishedResponses = maxConcurrentStreams != null ? (maxConcurrentStreams > Integer.MAX_VALUE ? Integer.MAX_VALUE : maxConcurrentStreams.intValue()) : Integer.MAX_VALUE;
            return;
        }
        try {
            String typeInfo = msg instanceof ByteBuf ? msg + " HexDump: " + ByteBufUtil.hexDump((ByteBuf)msg) : String.valueOf(msg);
            throw new IllegalStateException("unexpected message type: " + typeInfo + " (expected: ByteBuf)");
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(msg);
            throw throwable;
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SessionProtocol) {
            SessionProtocol protocol;
            assert (this.protocol == null);
            assert (this.responseDecoder == null);
            this.sessionTimeoutFuture.cancel(false);
            this.protocol = protocol = (SessionProtocol)((Object)evt);
            if (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C) {
                HttpResponseDecoder responseDecoder = this.isWebSocket() ? (HttpResponseDecoder)ctx.pipeline().get(WebSocketHttp1ClientChannelHandler.class) : (HttpResponseDecoder)ctx.pipeline().get(Http1ResponseDecoder.class);
                KeepAliveHandler keepAliveHandler = responseDecoder.keepAliveHandler();
                keepAliveHandler.initialize(ctx);
                ClientHttp1ObjectEncoder requestEncoder = new ClientHttp1ObjectEncoder(this.channel, protocol, this.clientFactory.http1HeaderNaming(), keepAliveHandler, this.isWebSocket());
                if (keepAliveHandler instanceof Http1ClientKeepAliveHandler) {
                    ((Http1ClientKeepAliveHandler)keepAliveHandler).setEncoder(requestEncoder);
                }
                this.requestEncoder = requestEncoder;
                this.responseDecoder = responseDecoder;
            } else if (protocol == SessionProtocol.H2 || protocol == SessionProtocol.H2C) {
                ChannelHandlerContext connectionHandlerCtx = ctx.pipeline().context(Http2ClientConnectionHandler.class);
                Http2ClientConnectionHandler connectionHandler = (Http2ClientConnectionHandler)connectionHandlerCtx.handler();
                this.requestEncoder = new ClientHttp2ObjectEncoder(connectionHandlerCtx, connectionHandler, protocol);
                this.responseDecoder = connectionHandler.responseDecoder();
            } else {
                throw new Error();
            }
            if (this.poolKey.proxyConfig.proxyType() != ProxyType.DIRECT) {
                if (this.proxyDestinationAddress != null) {
                    this.tryCompleteSessionPromise(ctx);
                }
            } else {
                this.tryCompleteSessionPromise(ctx);
            }
            return;
        }
        if (evt instanceof SessionProtocolNegotiationException || evt instanceof ProxyConnectException) {
            this.sessionTimeoutFuture.cancel(false);
            this.sessionPromise.tryFailure((Throwable)evt);
            ctx.close();
            return;
        }
        if (evt instanceof SslCompletionEvent) {
            SslCompletionEvent sslCompletionEvent = (SslCompletionEvent)evt;
            if (!sslCompletionEvent.isSuccess()) {
                Throwable handshakeException = sslCompletionEvent.cause();
                Throwable pendingException = HttpSessionHandler.getPendingException(ctx);
                if (pendingException != null && handshakeException != pendingException) {
                    pendingException.addSuppressed(handshakeException);
                    handshakeException = pendingException;
                }
                this.sessionTimeoutFuture.cancel(false);
                this.sessionPromise.tryFailure(handshakeException);
                ctx.close();
            }
            return;
        }
        if (evt instanceof Http2ConnectionPrefaceAndSettingsFrameWrittenEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        if (evt instanceof ProxyConnectionEvent) {
            this.proxyDestinationAddress = ((ProxyConnectionEvent)evt).destinationAddress();
            if (this.protocol != null) {
                this.tryCompleteSessionPromise(ctx);
            }
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)this.channel, evt);
    }

    private void tryCompleteSessionPromise(ChannelHandlerContext ctx) {
        if (!this.sessionPromise.trySuccess(this.channel)) {
            ctx.close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.isAcquirable = false;
        if (this.retryProtocol != null) {
            assert (this.responseDecoder == null || !this.responseDecoder.hasUnfinishedResponses());
            this.sessionTimeoutFuture.cancel(false);
            if (this.proxyDestinationAddress != null) {
                this.channelPool.connect(this.proxyDestinationAddress, this.retryProtocol, this.serializationFormat, this.poolKey, this.sessionPromise);
            } else {
                this.channelPool.connect(this.remoteAddress, this.retryProtocol, this.serializationFormat, this.poolKey, this.sessionPromise);
            }
        } else {
            Throwable pendingException;
            HttpResponseDecoder responseDecoder = this.responseDecoder;
            if (responseDecoder != null && responseDecoder.hasUnfinishedResponses()) {
                pendingException = HttpSessionHandler.maybeGetPendingException(ctx);
                responseDecoder.failUnfinishedResponses(pendingException);
            } else {
                pendingException = null;
            }
            this.sessionTimeoutFuture.cancel(false);
            if (!this.sessionPromise.isDone()) {
                this.sessionPromise.tryFailure(pendingException != null ? pendingException : HttpSessionHandler.maybeGetPendingException(ctx));
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ProxyConnectException) {
            SessionProtocol protocol = this.protocol != null ? this.protocol : this.desiredProtocol;
            UnprocessedRequestException wrapped = UnprocessedRequestException.of(cause);
            this.channelPool.maybeHandleProxyFailure(protocol, this.poolKey, wrapped);
            this.sessionPromise.tryFailure(wrapped);
            return;
        }
        HttpSessionHandler.setPendingException(ctx, new ClosedSessionException(cause));
        if (!(cause instanceof IOException)) {
            ctx.close();
        }
    }

    private static Throwable maybeGetPendingException(ChannelHandlerContext ctx) {
        Throwable pendingException = HttpSessionHandler.getPendingException(ctx);
        if (pendingException != null) {
            return pendingException;
        }
        return ClosedSessionException.get();
    }

    @Nullable
    private static Throwable getPendingException(ChannelHandlerContext ctx) {
        if (ctx.channel().hasAttr(PENDING_EXCEPTION)) {
            return ctx.channel().attr(PENDING_EXCEPTION).get();
        }
        return null;
    }

    static void setPendingException(ChannelHandlerContext ctx, Throwable cause) {
        Throwable previousCause = ctx.channel().attr(PENDING_EXCEPTION).setIfAbsent(cause);
        if (previousCause != null && logger.isWarnEnabled()) {
            logger.warn("{} Unexpected suppressed exception:", (Object)ctx.channel(), (Object)cause);
        }
    }
}

