/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.Http2ClientKeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.client.Http2ResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.HttpClientFactory;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeters;
import io.opentelemetry.testing.internal.armeria.internal.common.AbstractHttp2ConnectionHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.internal.common.KeepAliveHandlerUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.NoopKeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Tag;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Timer;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Settings;

final class Http2ClientConnectionHandler
extends AbstractHttp2ConnectionHandler {
    private final HttpClientFactory clientFactory;
    private final Http2ResponseDecoder responseDecoder;

    Http2ClientConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        super(decoder, encoder, initialSettings, Http2ClientConnectionHandler.newKeepAliveHandler(encoder, channel, clientFactory, protocol));
        this.clientFactory = clientFactory;
        this.responseDecoder = new Http2ResponseDecoder(channel, this.encoder(), clientFactory, this.keepAliveHandler());
        this.connection().addListener(this.responseDecoder);
        this.decoder().frameListener(this.responseDecoder);
    }

    private static KeepAliveHandler newKeepAliveHandler(Http2ConnectionEncoder encoder, Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        int maxNumRequestsPerConnection;
        long maxConnectionAgeMillis;
        long idleTimeoutMillis = clientFactory.idleTimeoutMillis();
        boolean keepAliveOnPing = clientFactory.keepAliveOnPing();
        long pingIntervalMillis = clientFactory.pingIntervalMillis();
        boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis = clientFactory.maxConnectionAgeMillis(), maxNumRequestsPerConnection = clientFactory.maxNumRequestsPerConnection());
        if (!needsKeepAliveHandler) {
            return new NoopKeepAliveHandler();
        }
        Timer keepAliveTimer = MoreMeters.newTimer(clientFactory.meterRegistry(), "armeria.client.connections.lifespan", ImmutableList.of(Tag.of("protocol", protocol.uriText())));
        return new Http2ClientKeepAliveHandler(channel, encoder.frameWriter(), keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
    }

    Http2ResponseDecoder responseDecoder() {
        return this.responseDecoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.handlerAdded(ctx);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.handlerRemoved0(ctx);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelRegistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelActive(ctx);
        ctx.flush();
    }

    @Override
    protected boolean needsImmediateDisconnection() {
        return this.clientFactory.isClosing() || this.responseDecoder.goAwayHandler().receivedErrorGoAway() || this.keepAliveHandler().isClosing();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.channelInactive(ctx);
    }

    private void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.keepAliveHandler().initialize(ctx);
        }
    }

    private void destroyKeepAliveHandler() {
        this.keepAliveHandler().destroy();
    }
}

