/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.BlockingWebClient;
import io.opentelemetry.testing.internal.armeria.client.BlockingWebClientRequestPreparation;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.ResponseAs;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import java.net.URI;

final class DefaultBlockingWebClient
implements BlockingWebClient {
    static final DefaultBlockingWebClient DEFAULT = new DefaultBlockingWebClient(WebClient.of());
    private final WebClient delegate;

    DefaultBlockingWebClient(WebClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public AggregatedHttpResponse execute(HttpRequest req, RequestOptions options) {
        if (options.exchangeType() == null) {
            options = options.toBuilder().exchangeType(ExchangeType.UNARY).build();
        }
        return ResponseAs.blocking().as(this.delegate.execute(req, options));
    }

    @Override
    public BlockingWebClientRequestPreparation prepare() {
        return new BlockingWebClientRequestPreparation(this.delegate.prepare());
    }

    @Override
    public Scheme scheme() {
        return this.delegate.scheme();
    }

    @Override
    public EndpointGroup endpointGroup() {
        return this.delegate.endpointGroup();
    }

    @Override
    public String absolutePathRef() {
        return this.delegate.absolutePathRef();
    }

    @Override
    public URI uri() {
        return this.delegate.uri();
    }

    @Override
    public Class<?> clientType() {
        return BlockingWebClient.class;
    }

    @Override
    public ClientOptions options() {
        return this.delegate.options();
    }

    @Override
    public HttpClient unwrap() {
        return this.delegate.unwrap();
    }

    @Override
    public Object unwrapAll() {
        return this.delegate.unwrapAll();
    }
}

