/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.net.InetSocketAddress;
import java.util.Objects;

final class ConnectionPoolMetrics {
    private static final String PROTOCOL = "protocol";
    private static final String REMOTE_IP = "remote.ip";
    private static final String LOCAL_IP = "local.ip";
    private static final String STATE = "state";
    private final MeterRegistry meterRegistry;
    private final MeterIdPrefix idPrefix;

    ConnectionPoolMetrics(MeterRegistry meterRegistry, MeterIdPrefix idPrefix) {
        this.idPrefix = Objects.requireNonNull(idPrefix, "idPrefix");
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
    }

    void increaseConnOpened(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        this.meterRegistry.counter(this.idPrefix.name(), this.idPrefix.tags(PROTOCOL, protocol.name(), REMOTE_IP, remoteAddr.getAddress().getHostAddress(), LOCAL_IP, localAddr.getAddress().getHostAddress(), STATE, "opened")).increment();
    }

    void increaseConnClosed(SessionProtocol protocol, InetSocketAddress remoteAddr, InetSocketAddress localAddr) {
        this.meterRegistry.counter(this.idPrefix.name(), this.idPrefix.tags(PROTOCOL, protocol.name(), REMOTE_IP, remoteAddr.getAddress().getHostAddress(), LOCAL_IP, localAddr.getAddress().getHostAddress(), STATE, "closed")).increment();
    }
}

