/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.common.AbstractRequestContextBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.ClientConnectionTimings;
import io.opentelemetry.testing.internal.armeria.common.util.SystemInfo;
import io.opentelemetry.testing.internal.armeria.internal.client.DefaultClientRequestContext;
import io.opentelemetry.testing.internal.armeria.internal.common.CancellationScheduler;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

public final class ClientRequestContextBuilder
extends AbstractRequestContextBuilder {
    private static final CancellationScheduler.CancellationTask noopCancellationTask = new CancellationScheduler.CancellationTask(){

        @Override
        public boolean canSchedule() {
            return true;
        }

        @Override
        public void run(Throwable cause) {
        }
    };
    static final CancellationScheduler noopResponseCancellationScheduler = new CancellationScheduler(0L);
    @Nullable
    private Endpoint endpoint;
    private ClientOptions options = ClientOptions.of();
    private RequestOptions requestOptions = RequestOptions.of();
    @Nullable
    private ClientConnectionTimings connectionTimings;

    ClientRequestContextBuilder(HttpRequest request) {
        super(false, request);
    }

    ClientRequestContextBuilder(RpcRequest request, URI uri) {
        super(false, request, uri);
    }

    @Override
    public ClientRequestContextBuilder method(HttpMethod method) {
        super.method(method);
        return this;
    }

    public ClientRequestContextBuilder endpoint(Endpoint endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
        return this;
    }

    public ClientRequestContextBuilder options(ClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
        return this;
    }

    public ClientRequestContextBuilder connectionTimings(ClientConnectionTimings connectionTimings) {
        this.connectionTimings = Objects.requireNonNull(connectionTimings, "connectionTimings");
        return this;
    }

    public ClientRequestContextBuilder requestOptions(RequestOptions requestOptions) {
        this.requestOptions = Objects.requireNonNull(requestOptions, "requestOptions");
        return this;
    }

    public ClientRequestContext build() {
        CancellationScheduler responseCancellationScheduler;
        Endpoint endpoint = this.endpoint != null ? this.endpoint : Endpoint.parse(this.authority());
        if (this.timedOut()) {
            responseCancellationScheduler = noopResponseCancellationScheduler;
        } else {
            responseCancellationScheduler = new CancellationScheduler(0L);
            CountDownLatch latch = new CountDownLatch(1);
            this.eventLoop().execute(() -> {
                responseCancellationScheduler.init(this.eventLoop(), noopCancellationTask, 0L, false);
                latch.countDown();
            });
            try {
                latch.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        DefaultClientRequestContext ctx = new DefaultClientRequestContext(this.eventLoop(), this.meterRegistry(), this.sessionProtocol(), this.id(), this.method(), this.requestTarget(), this.options, this.request(), this.rpcRequest(), this.requestOptions, responseCancellationScheduler, this.isRequestStartTimeSet() ? this.requestStartTimeNanos() : System.nanoTime(), this.isRequestStartTimeSet() ? this.requestStartTimeMicros() : SystemInfo.currentTimeMicros());
        ctx.init(endpoint);
        ctx.logBuilder().session(this.fakeChannel(), this.sessionProtocol(), this.sslSession(), this.connectionTimings);
        if (this.request() != null) {
            ctx.logBuilder().requestHeaders(this.request().headers());
        }
        if (this.rpcRequest() != null) {
            ctx.logBuilder().requestContent(this.rpcRequest(), null);
        }
        return ctx;
    }

    @Override
    public ClientRequestContextBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (ClientRequestContextBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public ClientRequestContextBuilder eventLoop(EventLoop eventLoop) {
        return (ClientRequestContextBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public ClientRequestContextBuilder alloc(ByteBufAllocator alloc) {
        return (ClientRequestContextBuilder)super.alloc(alloc);
    }

    @Override
    public ClientRequestContextBuilder sessionProtocol(SessionProtocol sessionProtocol) {
        return (ClientRequestContextBuilder)super.sessionProtocol(sessionProtocol);
    }

    @Override
    public ClientRequestContextBuilder id(RequestId id) {
        return (ClientRequestContextBuilder)super.id(id);
    }

    @Override
    public ClientRequestContextBuilder remoteAddress(InetSocketAddress remoteAddress) {
        return (ClientRequestContextBuilder)super.remoteAddress(remoteAddress);
    }

    @Override
    public ClientRequestContextBuilder localAddress(InetSocketAddress localAddress) {
        return (ClientRequestContextBuilder)super.localAddress(localAddress);
    }

    @Override
    public ClientRequestContextBuilder sslSession(SSLSession sslSession) {
        return (ClientRequestContextBuilder)super.sslSession(sslSession);
    }

    @Override
    public ClientRequestContextBuilder requestStartTime(long requestStartTimeNanos, long requestStartTimeMicros) {
        return (ClientRequestContextBuilder)super.requestStartTime(requestStartTimeNanos, requestStartTimeMicros);
    }

    @Override
    public ClientRequestContextBuilder timedOut(boolean timedOut) {
        return (ClientRequestContextBuilder)super.timedOut(timedOut);
    }

    static {
        noopResponseCancellationScheduler.init(ImmediateEventExecutor.INSTANCE, noopCancellationTask, 0L, false);
        noopResponseCancellationScheduler.finishNow();
    }
}

