/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContextBuilder;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.ResponseCancellationException;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.RpcRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.TimeoutMode;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ClientRequestContext
extends RequestContext {
    public static ClientRequestContext current() {
        Object ctx = RequestContext.current();
        Preconditions.checkState(ctx instanceof ClientRequestContext, "The current context is not a client-side context: %s", ctx);
        return (ClientRequestContext)ctx;
    }

    @Nullable
    public static ClientRequestContext currentOrNull() {
        Object ctx = RequestContext.currentOrNull();
        if (ctx instanceof ClientRequestContext) {
            return (ClientRequestContext)ctx;
        }
        return null;
    }

    @Nullable
    public static <T> T mapCurrent(Function<? super ClientRequestContext, T> mapper, @Nullable Supplier<T> defaultValueSupplier) {
        ClientRequestContext ctx = ClientRequestContext.currentOrNull();
        if (ctx != null) {
            return mapper.apply(ctx);
        }
        ServiceRequestContext serviceRequestContext = ServiceRequestContext.currentOrNull();
        if (serviceRequestContext != null) {
            throw new IllegalStateException("The current context is not a client-side context: " + serviceRequestContext);
        }
        if (defaultValueSupplier != null) {
            return defaultValueSupplier.get();
        }
        return null;
    }

    public static ClientRequestContext of(HttpRequest request) {
        return ClientRequestContext.builder(request).build();
    }

    public static ClientRequestContext of(RpcRequest request, String uri) {
        return ClientRequestContext.builder(request, URI.create(Objects.requireNonNull(uri, "uri"))).build();
    }

    public static ClientRequestContext of(RpcRequest request, URI uri) {
        return ClientRequestContext.builder(request, uri).build();
    }

    public static ClientRequestContextBuilder builder(HttpRequest request) {
        return new ClientRequestContextBuilder(request);
    }

    public static ClientRequestContextBuilder builder(RpcRequest request, String uri) {
        return ClientRequestContext.builder(request, URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static ClientRequestContextBuilder builder(RpcRequest request, URI uri) {
        return new ClientRequestContextBuilder(request, uri);
    }

    @Override
    @Nullable
    public HttpRequest request();

    @Override
    @Nullable
    public RpcRequest rpcRequest();

    @Override
    @MustBeClosed
    default public SafeCloseable push() {
        Object oldCtx = RequestContextUtil.getAndSet(this);
        if (oldCtx == null) {
            return RequestContextUtil.invokeHookAndPop(this, null);
        }
        if (oldCtx.unwrapAll() == this.unwrapAll()) {
            return RequestContextUtil.noopSafeCloseable();
        }
        ServiceRequestContext root = this.root();
        if (RequestContextUtil.equalsIgnoreWrapper(oldCtx.root(), root)) {
            return RequestContextUtil.invokeHookAndPop(this, oldCtx);
        }
        RequestContextUtil.pop(this, oldCtx);
        throw RequestContextUtil.newIllegalContextPushingException(this, oldCtx);
    }

    public ClientRequestContext newDerivedContext(RequestId var1, @Nullable HttpRequest var2, @Nullable RpcRequest var3, @Nullable Endpoint var4);

    @Nullable
    public EndpointGroup endpointGroup();

    @Nullable
    public Endpoint endpoint();

    public ClientOptions options();

    @Nullable
    public String fragment();

    @Nullable
    @UnstableApi
    public String authority();

    @Override
    @UnstableApi
    public URI uri();

    public long writeTimeoutMillis();

    public void setWriteTimeoutMillis(long var1);

    public void setWriteTimeout(Duration var1);

    public long responseTimeoutMillis();

    public void clearResponseTimeout();

    public void setResponseTimeoutMillis(TimeoutMode var1, long var2);

    default public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        this.setResponseTimeoutMillis(TimeoutMode.SET_FROM_NOW, responseTimeoutMillis);
    }

    public void setResponseTimeout(TimeoutMode var1, Duration var2);

    default public void setResponseTimeout(Duration responseTimeout) {
        this.setResponseTimeout(TimeoutMode.SET_FROM_NOW, responseTimeout);
    }

    public CompletableFuture<Throwable> whenResponseCancelling();

    public CompletableFuture<Throwable> whenResponseCancelled();

    @Deprecated
    public CompletableFuture<Void> whenResponseTimingOut();

    @Deprecated
    public CompletableFuture<Void> whenResponseTimedOut();

    @Override
    default public void cancel() {
        this.cancel(ResponseCancellationException.get());
    }

    @Override
    default public void timeoutNow() {
        this.cancel(ResponseTimeoutException.get());
    }

    public long maxResponseLength();

    public void setMaxResponseLength(long var1);

    @UnstableApi
    public HttpHeaders defaultRequestHeaders();

    public HttpHeaders additionalRequestHeaders();

    public void setAdditionalRequestHeader(CharSequence var1, Object var2);

    public void addAdditionalRequestHeader(CharSequence var1, Object var2);

    public void mutateAdditionalRequestHeaders(Consumer<HttpHeadersBuilder> var1);

    @Override
    @UnstableApi
    public CompletableFuture<Void> initiateConnectionShutdown();

    @Override
    @UnstableApi
    public ExchangeType exchangeType();

    @Override
    default public ClientRequestContext unwrap() {
        return (ClientRequestContext)RequestContext.super.unwrap();
    }

    @Override
    default public ClientRequestContext unwrapAll() {
        return (ClientRequestContext)RequestContext.super.unwrapAll();
    }
}

