/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.Http2ClientConnectionHandler;
import io.opentelemetry.testing.internal.armeria.client.Http2ClientKeepAliveHandler;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.stream.ClosedStreamException;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.Http2ObjectEncoder;
import io.opentelemetry.testing.internal.armeria.internal.common.NoopKeepAliveHandler;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Connection;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Headers;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2LocalFlowController;
import java.net.InetSocketAddress;
import java.util.Objects;

final class ClientHttp2ObjectEncoder
extends Http2ObjectEncoder
implements ClientHttpObjectEncoder {
    private final SessionProtocol protocol;

    ClientHttp2ObjectEncoder(ChannelHandlerContext connectionHandlerCtx, Http2ClientConnectionHandler connectionHandler, SessionProtocol protocol) {
        super(connectionHandlerCtx, connectionHandler);
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        assert (this.keepAliveHandler() instanceof Http2ClientKeepAliveHandler || this.keepAliveHandler() instanceof NoopKeepAliveHandler);
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, RequestHeaders headers, boolean endStream, ChannelPromise promise) {
        Http2Connection conn = this.encoder().connection();
        if (this.isStreamPresentAndWritable(streamId)) {
            this.keepAliveHandler().onReadOrWrite();
            return this.encoder().writeHeaders(this.ctx(), streamId, this.convertHeaders(headers), 0, endStream, promise);
        }
        Http2Connection.Endpoint<Http2LocalFlowController> local = conn.local();
        if (local.mayHaveCreatedStream(streamId)) {
            ClosedStreamException closedStreamException = new ClosedStreamException("Cannot create a new stream. streamId: " + streamId + ", lastStreamCreated: " + local.lastStreamCreated());
            return this.newFailedFuture(UnprocessedRequestException.of(closedStreamException));
        }
        return this.encoder().writeHeaders(this.ctx(), streamId, this.convertHeaders(headers), 0, endStream, promise);
    }

    private Http2Headers convertHeaders(HttpHeaders inputHeaders) {
        Http2Headers outputHeaders = ArmeriaHttpUtil.toNettyHttp2ClientHeaders(inputHeaders);
        if (!outputHeaders.contains(HttpHeaderNames.SCHEME)) {
            outputHeaders.add(HttpHeaderNames.SCHEME, this.protocol.isTls() ? SessionProtocol.HTTPS.uriText() : SessionProtocol.HTTP.uriText());
        }
        if (!outputHeaders.contains(HttpHeaderNames.AUTHORITY) && !outputHeaders.contains(HttpHeaderNames.HOST)) {
            InetSocketAddress remoteAddress = (InetSocketAddress)this.channel().remoteAddress();
            outputHeaders.add(HttpHeaderNames.AUTHORITY, ArmeriaHttpUtil.authorityHeader(remoteAddress.getHostName(), remoteAddress.getPort(), this.protocol.defaultPort()));
        }
        return outputHeaders;
    }

    @Override
    public ChannelFuture doWriteTrailers(int id, int streamId, HttpHeaders headers) {
        if (this.isStreamPresentAndWritable(streamId)) {
            this.keepAliveHandler().onReadOrWrite();
            return this.encoder().writeHeaders(this.ctx(), streamId, ArmeriaHttpUtil.toNettyHttp2ClientTrailers(headers), 0, true, this.ctx().newPromise());
        }
        return this.newFailedFuture(ClosedStreamException.get());
    }
}

