/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import io.opentelemetry.testing.internal.armeria.client.AggregatedResponseAs;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.ResponseAs;
import io.opentelemetry.testing.internal.armeria.client.TransformingRequestPreparation;
import io.opentelemetry.testing.internal.armeria.client.WebClientRequestPreparation;
import io.opentelemetry.testing.internal.armeria.client.WebRequestPreparationSetters;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseEntity;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import io.opentelemetry.testing.internal.jackson.core.type.TypeReference;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.reactivestreams.Publisher;

@UnstableApi
public final class BlockingWebClientRequestPreparation
implements WebRequestPreparationSetters<AggregatedHttpResponse> {
    private final WebClientRequestPreparation delegate;

    BlockingWebClientRequestPreparation(WebClientRequestPreparation delegate) {
        this.delegate = delegate;
        delegate.exchangeType(ExchangeType.UNARY);
    }

    @Override
    public AggregatedHttpResponse execute() {
        return ResponseAs.blocking().as(this.delegate.execute());
    }

    @UnstableApi
    public <U> TransformingRequestPreparation<AggregatedHttpResponse, U> as(ResponseAs<AggregatedHttpResponse, U> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return new TransformingRequestPreparation<AggregatedHttpResponse, U>(this, responseAs);
    }

    @UnstableApi
    public TransformingRequestPreparation<AggregatedHttpResponse, ResponseEntity<byte[]>> asBytes() {
        return this.as(AggregatedResponseAs.bytes());
    }

    @UnstableApi
    public TransformingRequestPreparation<AggregatedHttpResponse, ResponseEntity<String>> asString() {
        return this.as(AggregatedResponseAs.string());
    }

    @UnstableApi
    public <T> TransformingRequestPreparation<AggregatedHttpResponse, ResponseEntity<T>> asJson(Class<? extends T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.as(AggregatedResponseAs.json(clazz));
    }

    @UnstableApi
    public <T> TransformingRequestPreparation<AggregatedHttpResponse, ResponseEntity<T>> asJson(Class<? extends T> clazz, ObjectMapper mapper) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(mapper, "mapper");
        return this.as(AggregatedResponseAs.json(clazz, mapper));
    }

    @UnstableApi
    public <T> TransformingRequestPreparation<AggregatedHttpResponse, ResponseEntity<T>> asJson(TypeReference<? extends T> typeRef) {
        Objects.requireNonNull(typeRef, "typeRef");
        return this.as(AggregatedResponseAs.json(typeRef));
    }

    @UnstableApi
    public <T> TransformingRequestPreparation<AggregatedHttpResponse, ResponseEntity<T>> asJson(TypeReference<? extends T> typeRef, ObjectMapper mapper) {
        Objects.requireNonNull(typeRef, "typeRef");
        Objects.requireNonNull(mapper, "mapper");
        return this.as(AggregatedResponseAs.json(typeRef, mapper));
    }

    @Override
    public BlockingWebClientRequestPreparation exchangeType(ExchangeType exchangeType) {
        this.delegate.exchangeType(exchangeType);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation requestOptions(RequestOptions requestOptions) {
        this.delegate.requestOptions(requestOptions);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation get(String path) {
        this.delegate.get(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation post(String path) {
        this.delegate.post(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation put(String path) {
        this.delegate.put(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation delete(String path) {
        this.delegate.delete(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation patch(String path) {
        this.delegate.patch(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation options(String path) {
        this.delegate.options(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation head(String path) {
        this.delegate.head(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation trace(String path) {
        this.delegate.trace(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation method(HttpMethod method) {
        this.delegate.method(method);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation path(String path) {
        this.delegate.path(path);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(String content) {
        this.delegate.content(content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(MediaType contentType, CharSequence content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(MediaType contentType, String content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    @FormatMethod
    public BlockingWebClientRequestPreparation content(@FormatString String format, Object ... content) {
        this.delegate.content(format, content);
        return this;
    }

    @Override
    @FormatMethod
    public BlockingWebClientRequestPreparation content(MediaType contentType, @FormatString String format, Object ... content) {
        this.delegate.content(contentType, format, content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(MediaType contentType, byte[] content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(MediaType contentType, HttpData content) {
        this.delegate.content(contentType, content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(Publisher<? extends HttpData> content) {
        this.delegate.content((Publisher)content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation content(MediaType contentType, Publisher<? extends HttpData> content) {
        this.delegate.content(contentType, (Publisher)content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation contentJson(Object content) {
        this.delegate.contentJson(content);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation header(CharSequence name, Object value) {
        this.delegate.header(name, value);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        this.delegate.headers((Iterable)headers);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation trailer(CharSequence name, Object value) {
        this.delegate.trailer(name, value);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        this.delegate.trailers((Iterable)trailers);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation pathParam(String name, Object value) {
        this.delegate.pathParam(name, value);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation pathParams(Map<String, ?> pathParams) {
        this.delegate.pathParams((Map)pathParams);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation disablePathParams() {
        this.delegate.disablePathParams();
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation queryParam(String name, Object value) {
        this.delegate.queryParam(name, value);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation queryParams(Iterable<? extends Map.Entry<? extends String, String>> queryParams) {
        this.delegate.queryParams((Iterable)queryParams);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation cookie(Cookie cookie) {
        this.delegate.cookie(cookie);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation cookies(Iterable<? extends Cookie> cookies) {
        this.delegate.cookies((Iterable)cookies);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation responseTimeout(Duration responseTimeout) {
        this.delegate.responseTimeout(responseTimeout);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation responseTimeoutMillis(long responseTimeoutMillis) {
        this.delegate.responseTimeoutMillis(responseTimeoutMillis);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation writeTimeout(Duration writeTimeout) {
        this.delegate.writeTimeout(writeTimeout);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation writeTimeoutMillis(long writeTimeoutMillis) {
        this.delegate.writeTimeoutMillis(writeTimeoutMillis);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation maxResponseLength(long maxResponseLength) {
        this.delegate.maxResponseLength(maxResponseLength);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation requestAutoAbortDelay(Duration delay) {
        this.delegate.requestAutoAbortDelay(delay);
        return this;
    }

    @Override
    public BlockingWebClientRequestPreparation requestAutoAbortDelayMillis(long delayMillis) {
        this.delegate.requestAutoAbortDelayMillis(delayMillis);
        return this;
    }

    @Override
    public <V> BlockingWebClientRequestPreparation attr(AttributeKey<V> key, @Nullable V value) {
        this.delegate.attr((AttributeKey)key, (Object)value);
        return this;
    }
}

