/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractHttpRequestHandler;
import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import java.util.function.BiFunction;

final class AggregatedHttpRequestHandler
extends AbstractHttpRequestHandler
implements BiFunction<AggregatedHttpRequest, Throwable, Void> {
    private boolean cancelled;

    AggregatedHttpRequestHandler(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis) {
        super(ch, encoder, responseDecoder, originalRes, ctx, timeoutMillis, request.isEmpty(), true, true);
    }

    @Override
    public Void apply(@Nullable AggregatedHttpRequest request, @Nullable Throwable throwable) {
        EventLoop eventLoop = this.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.apply0(request, throwable);
        } else {
            eventLoop.execute(() -> this.apply0(request, throwable));
        }
        return null;
    }

    private void apply0(@Nullable AggregatedHttpRequest request, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.failRequest(throwable);
            return;
        }
        assert (request != null);
        if (!this.tryInitialize()) {
            request.content().close();
            return;
        }
        this.writeHeaders(request.headers());
        if (this.cancelled) {
            request.content().close();
            return;
        }
        HttpData content = request.content();
        boolean contentEmpty = content.isEmpty();
        HttpHeaders trailers = request.trailers();
        boolean trailersEmpty = trailers.isEmpty();
        if (!contentEmpty) {
            if (trailersEmpty) {
                content = content.withEndOfStream();
            }
            this.writeData(content);
        }
        if (!trailersEmpty) {
            this.writeTrailers(trailers);
        }
        this.channel().flush();
    }

    @Override
    void onWriteSuccess() {
    }

    @Override
    void cancel() {
        this.cancelled = true;
    }
}

