/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractClientOptionsBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.DecoratingRpcClientFunction;
import io.opentelemetry.testing.internal.armeria.client.RpcClient;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractWebClientBuilder
extends AbstractClientOptionsBuilder {
    @Nullable
    private final URI uri;
    @Nullable
    private final EndpointGroup endpointGroup;
    @Nullable
    private final Scheme scheme;
    @Nullable
    private final String path;

    protected AbstractWebClientBuilder() {
        this(ClientUtil.UNDEFINED_URI, null, null, null);
    }

    protected AbstractWebClientBuilder(URI uri) {
        this(AbstractWebClientBuilder.validateUri(uri), null, null, null);
    }

    protected AbstractWebClientBuilder(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable String path) {
        this(null, AbstractWebClientBuilder.validateSessionProtocol(sessionProtocol), Objects.requireNonNull(endpointGroup, "endpointGroup"), path);
    }

    protected AbstractWebClientBuilder(@Nullable URI uri, @Nullable Scheme scheme, @Nullable EndpointGroup endpointGroup, @Nullable String path) {
        assert (uri != null || scheme != null && endpointGroup != null);
        assert (path == null || uri == null);
        this.uri = uri;
        this.scheme = scheme;
        this.endpointGroup = endpointGroup;
        this.path = AbstractWebClientBuilder.validatePath(path);
    }

    private static URI validateUri(URI uri) {
        Objects.requireNonNull(uri, "uri");
        if (Clients.isUndefinedUri(uri)) {
            return uri;
        }
        String givenScheme = Objects.requireNonNull(uri, "uri").getScheme();
        Scheme scheme = AbstractWebClientBuilder.validateScheme(givenScheme);
        if (scheme.uriText().equals(givenScheme)) {
            return uri;
        }
        return URI.create(scheme.uriText() + uri.toString().substring(givenScheme.length()));
    }

    private static Scheme validateSessionProtocol(SessionProtocol sessionProtocol) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        AbstractWebClientBuilder.validateScheme(sessionProtocol.uriText());
        return Scheme.of(SerializationFormat.NONE, sessionProtocol);
    }

    private static Scheme validateScheme(String scheme) {
        Scheme parsedScheme = Scheme.tryParse(scheme);
        if (parsedScheme != null && parsedScheme.serializationFormat() == SerializationFormat.NONE && SessionProtocol.httpAndHttpsValues().contains((Object)parsedScheme.sessionProtocol())) {
            return parsedScheme;
        }
        throw new IllegalArgumentException("scheme: " + scheme + " (expected: one of " + SessionProtocol.httpAndHttpsValues() + ')');
    }

    @Nullable
    private static String validatePath(@Nullable String path) {
        if (path != null) {
            Preconditions.checkArgument(path.startsWith("/"), "path: %s (expected: an absolute path starting with '/')", (Object)path);
        }
        return path;
    }

    protected final WebClient buildWebClient() {
        ClientOptions options = this.buildOptions();
        ClientBuilderParams params = this.clientBuilderParams(options);
        ClientFactory factory = options.factory();
        return (WebClient)factory.newClient(params);
    }

    protected final ClientBuilderParams clientBuilderParams(ClientOptions options) {
        Objects.requireNonNull(options, "options");
        if (this.uri != null) {
            return ClientBuilderParams.of(this.uri, WebClient.class, options);
        }
        assert (this.scheme != null);
        assert (this.endpointGroup != null);
        return ClientBuilderParams.of(this.scheme, this.endpointGroup, this.path, WebClient.class, options);
    }

    @Override
    @Deprecated
    public AbstractWebClientBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        throw new UnsupportedOperationException("RPC decorator cannot be added to the web client builder.");
    }

    @Override
    @Deprecated
    public AbstractWebClientBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        throw new UnsupportedOperationException("RPC decorator cannot be added to the web client builder.");
    }
}

