/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.TimeoutException;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import java.util.Objects;
import java.util.function.BiPredicate;

@UnstableApi
public abstract class AbstractRuleBuilder {
    private final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, Throwable> exceptionFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter;

    protected AbstractRuleBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        this.requestHeadersFilter = requestHeadersFilter;
    }

    public AbstractRuleBuilder onResponseHeaders(BiPredicate<? super ClientRequestContext, ? super ResponseHeaders> responseHeadersFilter) {
        this.responseHeadersFilter = AbstractRuleBuilder.combinePredicates(this.responseHeadersFilter, responseHeadersFilter, "responseHeadersFilter");
        return this;
    }

    public AbstractRuleBuilder onResponseTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> responseTrailersFilter) {
        this.responseTrailersFilter = AbstractRuleBuilder.combinePredicates(this.responseTrailersFilter, responseTrailersFilter, "responseTrailersFilter");
        return this;
    }

    public AbstractRuleBuilder onGrpcTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> grpcTrailersFilter) {
        this.grpcTrailersFilter = AbstractRuleBuilder.combinePredicates(this.grpcTrailersFilter, grpcTrailersFilter, "grpcTrailersFilter");
        return this;
    }

    public AbstractRuleBuilder onStatusClass(HttpStatusClass ... statusClasses) {
        return this.onStatusClass(ImmutableSet.copyOf(Objects.requireNonNull(statusClasses, "statusClasses")));
    }

    public AbstractRuleBuilder onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        Objects.requireNonNull(statusClasses, "statusClasses");
        Preconditions.checkArgument(!Iterables.isEmpty(statusClasses), "statusClasses can't be empty.");
        ImmutableSet<HttpStatusClass> statusClasses0 = Sets.immutableEnumSet(statusClasses);
        this.onResponseHeaders((ctx, headers) -> statusClasses0.contains((Object)headers.status().codeClass()));
        return this;
    }

    public AbstractRuleBuilder onServerErrorStatus() {
        return this.onStatusClass(HttpStatusClass.SERVER_ERROR);
    }

    public AbstractRuleBuilder onStatus(HttpStatus ... statuses) {
        return this.onStatus(ImmutableSet.copyOf(Objects.requireNonNull(statuses, "statuses")));
    }

    public AbstractRuleBuilder onStatus(Iterable<HttpStatus> statuses) {
        Objects.requireNonNull(statuses, "statuses");
        Preconditions.checkArgument(!Iterables.isEmpty(statuses), "statuses can't be empty.");
        ImmutableSet<HttpStatus> statuses0 = ImmutableSet.copyOf(statuses);
        this.onResponseHeaders((ctx, headers) -> statuses0.contains(headers.status()));
        return this;
    }

    public AbstractRuleBuilder onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        Objects.requireNonNull(statusFilter, "statusFilter");
        this.onResponseHeaders((ctx, headers) -> statusFilter.test((ClientRequestContext)ctx, headers.status()));
        return this;
    }

    public AbstractRuleBuilder onException(Class<? extends Throwable> exception) {
        Objects.requireNonNull(exception, "exception");
        return this.onException((? super ClientRequestContext unused, ? super Throwable ex) -> exception.isInstance(ex));
    }

    public AbstractRuleBuilder onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        this.exceptionFilter = AbstractRuleBuilder.combinePredicates(this.exceptionFilter, exceptionFilter, "exceptionFilter");
        return this;
    }

    public AbstractRuleBuilder onException() {
        return this.onException((? super ClientRequestContext unused1, ? super Throwable unused2) -> true);
    }

    public AbstractRuleBuilder onTimeoutException() {
        return this.onException((? super ClientRequestContext ctx, ? super Throwable ex) -> {
            if (ctx.isTimedOut()) {
                return true;
            }
            return ex instanceof TimeoutException || ex instanceof UnprocessedRequestException && ex.getCause() instanceof TimeoutException;
        });
    }

    private static <T> BiPredicate<ClientRequestContext, T> combinePredicates(@Nullable BiPredicate<ClientRequestContext, T> firstPredicate, BiPredicate<? super ClientRequestContext, ? super T> secondPredicate, String paramName) {
        Objects.requireNonNull(secondPredicate, paramName);
        if (firstPredicate != null) {
            return firstPredicate.or(secondPredicate);
        }
        BiPredicate<? super ClientRequestContext, ? super T> cast = secondPredicate;
        return cast;
    }

    public AbstractRuleBuilder onUnprocessed() {
        return this.onException(UnprocessedRequestException.class);
    }

    protected final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter() {
        return this.requestHeadersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter() {
        return this.responseHeadersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter() {
        return this.responseTrailersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, Throwable> exceptionFilter() {
        return this.exceptionFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter() {
        return this.grpcTrailersFilter;
    }

    protected final boolean requiresResponseTrailers() {
        return this.responseTrailersFilter != null || this.grpcTrailersFilter != null;
    }
}

