/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractHttpRequestHandler;
import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpRequestSubscriber;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.client.WebSocketHttp1RequestSubscriber;
import io.opentelemetry.testing.internal.armeria.client.WebSocketHttp2RequestSubscriber;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractHttpRequestSubscriber
extends AbstractHttpRequestHandler
implements Subscriber<HttpObject> {
    private static final HttpData EMPTY_EOS = HttpData.empty().withEndOfStream();
    private final HttpRequest request;
    @Nullable
    private Subscription subscription;
    private boolean isSubscriptionCompleted;

    static AbstractHttpRequestSubscriber of(Channel channel, ClientHttpObjectEncoder requestEncoder, HttpResponseDecoder responseDecoder, SessionProtocol protocol, ClientRequestContext ctx, HttpRequest req, DecodedHttpResponse res, long writeTimeoutMillis, boolean webSocket) {
        if (webSocket) {
            if (protocol.isExplicitHttp1()) {
                return new WebSocketHttp1RequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
            }
            assert (protocol.isExplicitHttp2());
            return new WebSocketHttp2RequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
        }
        return new HttpRequestSubscriber(channel, requestEncoder, responseDecoder, req, res, ctx, writeTimeoutMillis);
    }

    AbstractHttpRequestSubscriber(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis, boolean allowTrailers, boolean keepAlive) {
        super(ch, encoder, responseDecoder, originalRes, ctx, timeoutMillis, request.isEmpty(), allowTrailers, keepAlive);
        this.request = request;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        assert (this.subscription == null);
        this.subscription = subscription;
        if (this.state() == AbstractHttpRequestHandler.State.DONE) {
            this.cancel();
            return;
        }
        if (!this.tryInitialize()) {
            return;
        }
        this.writeHeaders(this.mapHeaders(this.request.headers()));
        this.channel().flush();
    }

    RequestHeaders mapHeaders(RequestHeaders headers) {
        return headers;
    }

    @Override
    public void onError(Throwable cause) {
        this.isSubscriptionCompleted = true;
        this.failRequest(cause);
    }

    @Override
    public void onComplete() {
        this.isSubscriptionCompleted = true;
        if (this.state() != AbstractHttpRequestHandler.State.DONE) {
            this.writeData(EMPTY_EOS);
            this.channel().flush();
        }
    }

    @Override
    void onWriteSuccess() {
        if (!this.isSubscriptionCompleted) {
            assert (this.subscription != null);
            this.subscription.request(1L);
        }
    }

    @Override
    void cancel() {
        this.isSubscriptionCompleted = true;
        assert (this.subscription != null);
        this.subscription.cancel();
    }
}

