/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.util;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public final class TelemetryDataUtil {
    public static Comparator<List<SpanData>> orderByRootSpanKind(SpanKind ... spanKinds) {
        List<SpanKind> list = Arrays.asList(spanKinds);
        return Comparator.comparing(span -> list.indexOf(((SpanData)span.get(0)).getKind()));
    }

    public static Comparator<List<SpanData>> orderByRootSpanName(String ... names) {
        List<String> list = Arrays.asList(names);
        return Comparator.comparing(span -> list.indexOf(((SpanData)span.get(0)).getName()));
    }

    public static <T extends Comparable<T>> Comparator<List<SpanData>> comparingRootSpanAttribute(AttributeKey<T> key) {
        return Comparator.comparing(span -> (Comparable)((SpanData)span.get(0)).getAttributes().get(key), Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    public static List<List<SpanData>> groupTraces(List<SpanData> spans) {
        ArrayList<List<SpanData>> traces = new ArrayList<List<SpanData>>(spans.stream().collect(Collectors.groupingBy(SpanData::getTraceId, LinkedHashMap::new, Collectors.toList())).values());
        TelemetryDataUtil.sortTraces(traces);
        for (int i = 0; i < traces.size(); ++i) {
            List trace = (List)traces.get(i);
            traces.set(i, TelemetryDataUtil.sort(trace));
        }
        return traces;
    }

    public static List<List<SpanData>> waitForTraces(Supplier<List<SpanData>> supplier, int number) throws InterruptedException, TimeoutException {
        return TelemetryDataUtil.waitForTraces(supplier, number, 20L, TimeUnit.SECONDS);
    }

    public static List<List<SpanData>> waitForTraces(Supplier<List<SpanData>> supplier, int number, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long startTime = System.nanoTime();
        List<List<SpanData>> allTraces = TelemetryDataUtil.groupTraces(supplier.get());
        List<List<Object>> completeTraces = allTraces.stream().filter(TelemetryDataUtil::isCompleted).collect(Collectors.toList());
        while (completeTraces.size() < number && TelemetryDataUtil.elapsedSeconds(startTime) < unit.toSeconds(timeout)) {
            allTraces = TelemetryDataUtil.groupTraces(supplier.get());
            completeTraces = allTraces.stream().filter(TelemetryDataUtil::isCompleted).collect(Collectors.toList());
            Thread.sleep(10L);
        }
        if (completeTraces.size() < number) {
            throw new TimeoutException("Timeout waiting for " + number + " completed trace(s), found " + completeTraces.size() + " completed trace(s) and " + allTraces.size() + " total trace(s): " + allTraces);
        }
        return completeTraces;
    }

    public static void assertScopeVersion(List<List<SpanData>> traces) {
        for (List<SpanData> trace : traces) {
            for (SpanData span : trace) {
                if (span.getInstrumentationScopeInfo().getName().equals("test")) continue;
                ((AbstractStringAssert)Assertions.assertThat((String)span.getInstrumentationScopeInfo().getVersion()).as("Instrumentation version was empty; make sure that the instrumentation name matches the gradle module name", new Object[0])).isNotNull();
            }
        }
    }

    private static long elapsedSeconds(long startTime) {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
    }

    private static void sortTraces(List<List<SpanData>> traces) {
        traces.sort(Comparator.comparingLong(TelemetryDataUtil::getMinSpanOrder));
    }

    private static long getMinSpanOrder(List<SpanData> spans) {
        return spans.stream().mapToLong(SpanData::getStartEpochNanos).min().orElse(0L);
    }

    private static List<SpanData> sort(List<SpanData> trace) {
        LinkedHashMap<String, Node> lookup = new LinkedHashMap<String, Node>();
        for (SpanData span : trace) {
            lookup.put(span.getSpanId(), new Node(span));
        }
        for (Object node : lookup.values()) {
            Node parentNode;
            String parentSpanId = ((Node)node).span.getParentSpanId();
            if (!SpanId.isValid((CharSequence)parentSpanId) || (parentNode = (Node)lookup.get(parentSpanId)) == null) continue;
            parentNode.childNodes.add(node);
            ((Node)node).root = false;
        }
        ArrayList<Node> rootNodes = new ArrayList<Node>();
        for (Object node : lookup.values()) {
            TelemetryDataUtil.sortOneLevel(((Node)node).childNodes);
            if (!((Node)node).root) continue;
            rootNodes.add((Node)node);
        }
        TelemetryDataUtil.sortOneLevel(rootNodes);
        ArrayList<Node> orderedNodes = new ArrayList<Node>();
        for (Node rootNode : rootNodes) {
            TelemetryDataUtil.traversePreOrder(rootNode, orderedNodes);
        }
        ArrayList<SpanData> orderedSpans = new ArrayList<SpanData>();
        for (Node node : orderedNodes) {
            orderedSpans.add(node.span);
        }
        return orderedSpans;
    }

    private static void sortOneLevel(List<Node> nodes) {
        nodes.sort(Comparator.comparingLong(node -> ((Node)node).span.getStartEpochNanos()));
    }

    private static void traversePreOrder(Node node, List<Node> accumulator) {
        accumulator.add(node);
        for (Node child : node.childNodes) {
            TelemetryDataUtil.traversePreOrder(child, accumulator);
        }
    }

    private static boolean isCompleted(List<SpanData> trace) {
        for (SpanData span : trace) {
            if (!SpanId.isValid((CharSequence)span.getParentSpanId())) {
                return true;
            }
            if (!span.getParentSpanId().equals("0000000000000456")) continue;
            return true;
        }
        return false;
    }

    private TelemetryDataUtil() {
    }

    private static class Node {
        private final SpanData span;
        private final List<Node> childNodes = new ArrayList<Node>();
        private boolean root = true;

        private Node(SpanData span) {
            this.span = span;
        }
    }
}

