/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import io.opentelemetry.api.trace.Span;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class ServerEndpoint {
    private static final Map<String, ServerEndpoint> PATH_MAP = new HashMap<String, ServerEndpoint>();
    public static final ServerEndpoint SUCCESS = new ServerEndpoint("SUCCESS", "success", 200, "success");
    public static final ServerEndpoint REDIRECT = new ServerEndpoint("REDIRECT", "redirect", 302, "/redirected");
    public static final ServerEndpoint ERROR = new ServerEndpoint("ERROR", "error-status", 500, "controller error");
    public static final ServerEndpoint EXCEPTION = new ServerEndpoint("EXCEPTION", "exception", 500, "controller exception");
    public static final ServerEndpoint NOT_FOUND = new ServerEndpoint("NOT_FOUND", "notFound", 404, "not found");
    public static final ServerEndpoint CAPTURE_HEADERS = new ServerEndpoint("CAPTURE_HEADERS", "captureHeaders", 200, "headers captured");
    public static final ServerEndpoint CAPTURE_PARAMETERS = new ServerEndpoint("CAPTURE_PARAMETERS", "captureParameters", 200, "parameters captured");
    public static final ServerEndpoint QUERY_PARAM = new ServerEndpoint("QUERY_PARAM", "query?some=query", 200, "some=query");
    public static final ServerEndpoint PATH_PARAM = new ServerEndpoint("PATH_PARAM", "path/123/param", 200, "123");
    public static final ServerEndpoint AUTH_REQUIRED = new ServerEndpoint("AUTH_REQUIRED", "authRequired", 200, null);
    public static final ServerEndpoint LOGIN = new ServerEndpoint("LOGIN", "login", 302, null);
    public static final ServerEndpoint AUTH_ERROR = new ServerEndpoint("AUTH_ERROR", "basicsecured/endpoint", 401, null);
    public static final ServerEndpoint INDEXED_CHILD = new ServerEndpoint("INDEXED_CHILD", "child", 200, "");
    public static final String ID_ATTRIBUTE_NAME = "test.request.id";
    public static final String ID_PARAMETER_NAME = "id";
    private final String name;
    private final URI uriObj;
    private final String path;
    final String query;
    final String fragment;
    final int status;
    final String body;

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public String name() {
        return this.name;
    }

    public ServerEndpoint(String name, String uri, int status, String body) {
        this(name, uri, status, body, true);
    }

    public ServerEndpoint(String name, String uri, int status, String body, boolean registerPath) {
        this.name = name;
        this.uriObj = URI.create(uri);
        this.path = this.uriObj.getPath();
        this.query = this.uriObj.getQuery();
        this.fragment = this.uriObj.getFragment();
        this.status = status;
        this.body = body;
        if (registerPath) {
            PATH_MAP.put(this.getPath(), this);
        }
    }

    public String getPath() {
        return "/" + this.path;
    }

    public String rawPath() {
        return this.path;
    }

    URI resolvePath(URI address) {
        return address.resolve(this.path);
    }

    URI resolve(URI address) {
        return address.resolve(this.uriObj);
    }

    URI resolveWithoutFragment(URI address) throws URISyntaxException {
        URI uri = this.resolve(address);
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
    }

    public void collectSpanAttributes(UrlParameterProvider parameterProvider) {
        String value;
        if (this == INDEXED_CHILD && (value = parameterProvider.getParameter(ID_PARAMETER_NAME)) != null) {
            Span.current().setAttribute(ID_ATTRIBUTE_NAME, Long.parseLong(value));
        }
    }

    public static ServerEndpoint forPath(String path) {
        return PATH_MAP.get(path);
    }

    public static interface UrlParameterProvider {
        public String getParameter(String var1);
    }
}

