/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import io.opentelemetry.instrumentation.testing.AgentTestRunner;
import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.instrumentation.testing.LibraryTestRunner;
import io.opentelemetry.instrumentation.testing.junit.InstrumentationExtension;
import io.opentelemetry.instrumentation.testing.junit.http.AbstractHttpClientTest;
import io.opentelemetry.instrumentation.testing.junit.http.HttpClientTestServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class HttpClientInstrumentationExtension
extends InstrumentationExtension {
    private final HttpClientTestServer server = new HttpClientTestServer(this.getOpenTelemetry());

    public static InstrumentationExtension forAgent() {
        return new HttpClientInstrumentationExtension(AgentTestRunner.instance());
    }

    public static InstrumentationExtension forLibrary() {
        return new HttpClientInstrumentationExtension(LibraryTestRunner.instance());
    }

    private HttpClientInstrumentationExtension(InstrumentationTestRunner runner) {
        super(runner);
    }

    @Override
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        super.beforeAll(extensionContext);
        this.server.beforeAll(extensionContext);
    }

    @Override
    public void beforeEach(ExtensionContext extensionContext) {
        super.beforeEach(extensionContext);
        Object testInstance = extensionContext.getRequiredTestInstance();
        if (!(testInstance instanceof AbstractHttpClientTest)) {
            throw new AssertionError((Object)"HttpClientInstrumentationExtension can only be applied to a subclass of AbstractHttpClientTest");
        }
        ((AbstractHttpClientTest)testInstance).setTesting(this.getTestRunner(), this.server);
    }

    @Override
    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        this.server.afterAll(extensionContext);
    }
}

