/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.opentelemetry.instrumentation.api.instrumenter.url.internal.UrlAttributes;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.testing.GlobalTraceUtil;
import io.opentelemetry.instrumentation.testing.junit.http.AbstractHttpServerUsingTest;
import io.opentelemetry.instrumentation.testing.junit.http.HttpServerTestOptions;
import io.opentelemetry.instrumentation.testing.junit.http.SemconvStabilityUtil;
import io.opentelemetry.instrumentation.testing.junit.http.ServerEndpoint;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.testing.assertj.TraceAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.semconv.SemanticAttributes;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestBuilder;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.QueryParams;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.io.netty.bootstrap.Bootstrap;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelInitializer;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelOption;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPipeline;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.SimpleChannelInboundHandler;
import io.opentelemetry.testing.internal.io.netty.channel.nio.NioEventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.socket.SocketChannel;
import io.opentelemetry.testing.internal.io.netty.channel.socket.nio.NioSocketChannel;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultHttpResponse;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpClientCodec;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpMethod;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpObject;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AssertAccess;
import org.assertj.core.api.ThrowingConsumer;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractHttpServerTest<SERVER>
extends AbstractHttpServerUsingTest<SERVER> {
    public static final String TEST_REQUEST_HEADER = "X-Test-Request";
    public static final String TEST_RESPONSE_HEADER = "X-Test-Response";
    private final HttpServerTestOptions options = new HttpServerTestOptions();

    @BeforeAll
    void setupOptions() {
        this.options.expectedServerSpanNameMapper = this::expectedServerSpanName;
        this.options.expectedHttpRoute = this::expectedHttpRoute;
        this.configure(this.options);
        this.startServer();
    }

    @AfterAll
    void cleanup() {
        this.cleanupServer();
    }

    @Override
    protected final String getContextPath() {
        return this.options.contextPath;
    }

    protected void configure(HttpServerTestOptions options) {
    }

    public static <T> T controller(ServerEndpoint endpoint, Supplier<T> closure) {
        assert (Span.current().getSpanContext().isValid()) : "Controller should have a parent span.";
        if (endpoint == ServerEndpoint.NOT_FOUND) {
            return closure.get();
        }
        return (T)GlobalTraceUtil.runWithSpan("controller", () -> closure.get());
    }

    protected AggregatedHttpRequest request(ServerEndpoint uri, String method) {
        return AggregatedHttpRequest.of(io.opentelemetry.testing.internal.armeria.common.HttpMethod.valueOf(method), this.resolveAddress(uri));
    }

    @ParameterizedTest
    @ValueSource(ints={1, 4, 50})
    void successfulGetRequest(int count) {
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.SUCCESS, method);
        ArrayList<AggregatedHttpResponse> responses = new ArrayList<AggregatedHttpResponse>();
        for (int i = 0; i < count; ++i) {
            responses.add(this.client.execute(request).aggregate().join());
        }
        for (AggregatedHttpResponse response : responses) {
            OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
            OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
            this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.SUCCESS, null);
        }
        this.assertTheTraces(count, null, null, null, method, ServerEndpoint.SUCCESS, (AggregatedHttpResponse)responses.get(0));
    }

    @Test
    void successfulGetRequestWithParent() {
        String method = "GET";
        String traceId = "00000000000000000000000000000123";
        String parentId = "0000000000000456";
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.SUCCESS, method).headers().toBuilder().set((CharSequence)"tracePARENT", "00-" + traceId + "-" + parentId + "-01").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.SUCCESS, traceId);
        this.assertTheTraces(1, traceId, parentId, spanId, "GET", ServerEndpoint.SUCCESS, response);
    }

    @Test
    void tracingHeaderIsCaseInsensitive() {
        String method = "GET";
        String traceId = "00000000000000000000000000000123";
        String parentId = "0000000000000456";
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.SUCCESS, method).headers().toBuilder().set((CharSequence)"TRACEPARENT", "00-" + traceId + "-" + parentId + "-01").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.SUCCESS, traceId);
        this.assertTheTraces(1, traceId, parentId, spanId, "GET", ServerEndpoint.SUCCESS, response);
    }

    @ParameterizedTest
    @MethodSource(value={"provideServerEndpoints"})
    void requestWithQueryString(ServerEndpoint endpoint) {
        String method = "GET";
        AggregatedHttpRequest request = this.request(endpoint, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(endpoint.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(endpoint.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, endpoint, null);
        this.assertTheTraces(1, null, null, spanId, method, endpoint, response);
    }

    private static Stream<ServerEndpoint> provideServerEndpoints() {
        return Stream.of(ServerEndpoint.SUCCESS, ServerEndpoint.QUERY_PARAM);
    }

    @Test
    void requestWithRedirect() {
        Assumptions.assumeTrue((boolean)this.options.testRedirect);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.REDIRECT, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.REDIRECT.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.headers().get("location")).satisfiesAnyOf(new ThrowingConsumer[]{location -> OpenTelemetryAssertions.assertThat((String)location).isEqualTo(ServerEndpoint.REDIRECT.getBody()), location -> OpenTelemetryAssertions.assertThat((String)new URI((String)location).normalize().toString()).isEqualTo(this.address.resolve(ServerEndpoint.REDIRECT.getBody()).toString())});
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.REDIRECT, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.REDIRECT, response);
    }

    @Test
    void requestWithError() {
        Assumptions.assumeTrue((boolean)this.options.testError);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.ERROR, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.ERROR.getStatus());
        if (this.options.testErrorBody) {
            OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.ERROR.getBody());
        }
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.ERROR, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.ERROR, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void requestWithException() {
        Assumptions.assumeTrue((boolean)this.options.testException);
        Awaitility.doNotCatchUncaughtExceptionsByDefault();
        try {
            String method = "GET";
            AggregatedHttpRequest request = this.request(ServerEndpoint.EXCEPTION, method);
            AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
            OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.EXCEPTION.getStatus());
            String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.EXCEPTION, null);
            this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.EXCEPTION, response);
        }
        finally {
            Awaitility.reset();
        }
    }

    @Test
    void requestForNotFound() {
        Assumptions.assumeTrue((boolean)this.options.testNotFound);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.NOT_FOUND, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.NOT_FOUND.getStatus());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.NOT_FOUND, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.NOT_FOUND, response);
    }

    @Test
    void requestWithPathParameter() {
        Assumptions.assumeTrue((boolean)this.options.testPathParam);
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.PATH_PARAM, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.PATH_PARAM.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.PATH_PARAM.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.PATH_PARAM, null);
        this.assertTheTraces(1, null, null, spanId, method, ServerEndpoint.PATH_PARAM, response);
    }

    @Test
    void captureHttpHeaders() {
        Assumptions.assumeTrue((boolean)this.options.testCaptureHttpHeaders);
        AggregatedHttpRequest request = AggregatedHttpRequest.of(this.request(ServerEndpoint.CAPTURE_HEADERS, "GET").headers().toBuilder().add((CharSequence)TEST_REQUEST_HEADER, "test").build());
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.CAPTURE_HEADERS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.CAPTURE_HEADERS.getBody());
        OpenTelemetryAssertions.assertThat((String)response.headers().get(TEST_RESPONSE_HEADER)).isEqualTo("test");
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.CAPTURE_HEADERS, null);
        this.assertTheTraces(1, null, null, spanId, "GET", ServerEndpoint.CAPTURE_HEADERS, response);
    }

    @Test
    void captureRequestParameters() {
        Assumptions.assumeTrue((boolean)this.options.testCaptureRequestParameters);
        QueryParams formBody = QueryParams.builder().add("test-parameter", "test value \u00f5\u00e4\u00f6\u00fc").build();
        AggregatedHttpRequest request = AggregatedHttpRequest.of(RequestHeaders.builder(io.opentelemetry.testing.internal.armeria.common.HttpMethod.POST, this.resolveAddress(ServerEndpoint.CAPTURE_PARAMETERS)).contentType(MediaType.FORM_DATA).build(), HttpData.ofUtf8(formBody.toQueryString()));
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.CAPTURE_PARAMETERS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.CAPTURE_PARAMETERS.getBody());
        String spanId = this.assertResponseHasCustomizedHeaders(response, ServerEndpoint.CAPTURE_PARAMETERS, null);
        this.assertTheTraces(1, null, null, spanId, "POST", ServerEndpoint.CAPTURE_PARAMETERS, response);
    }

    @Test
    void httpServerMetrics() {
        String method = "GET";
        AggregatedHttpRequest request = this.request(ServerEndpoint.SUCCESS, method);
        AggregatedHttpResponse response = this.client.execute(request).aggregate().join();
        OpenTelemetryAssertions.assertThat((int)response.status().code()).isEqualTo(ServerEndpoint.SUCCESS.getStatus());
        OpenTelemetryAssertions.assertThat((String)response.contentUtf8()).isEqualTo(ServerEndpoint.SUCCESS.getBody());
        AtomicReference instrumentationName = new AtomicReference();
        this.testing.waitAndAssertTraces(trace -> {
            instrumentationName.set(trace.getSpan(0).getInstrumentationScopeInfo().getName());
            trace.anySatisfy(spanData -> this.assertServerSpan(OpenTelemetryAssertions.assertThat((SpanData)spanData), method, ServerEndpoint.SUCCESS));
        });
        String durationInstrumentName = SemconvStability.emitStableHttpSemconv() ? "http.server.request.duration" : "http.server.duration";
        String metricsInstrumentationName = this.options.metricsInstrumentationName.get();
        if (metricsInstrumentationName == null) {
            metricsInstrumentationName = (String)instrumentationName.get();
        }
        this.testing.waitAndAssertMetrics(metricsInstrumentationName, durationInstrumentName, metrics -> metrics.anySatisfy(metric -> OpenTelemetryAssertions.assertThat((MetricData)metric).hasDescription("The duration of the inbound HTTP request").hasUnit(SemconvStability.emitStableHttpSemconv() ? "s" : "ms").hasHistogramSatisfying(histogram -> histogram.hasPointsSatisfying(new Consumer[]{point -> point.hasSumGreaterThan(0.0)}))));
    }

    @Test
    void highConcurrency() throws InterruptedException {
        int count = 100;
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        CountDownLatch latch = new CountDownLatch(count);
        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        TextMapSetter setter = HttpRequestBuilder::header;
        int i = 0;
        while (i < count) {
            int index = i++;
            HttpRequestBuilder request = HttpRequest.builder().get(endpoint.resolvePath(this.address).toString().replace("http://", "h1c://")).queryParam("id", index);
            this.testing.runWithSpan("client " + index, () -> {
                Span.current().setAttribute("test.request.id", (long)index);
                propagator.inject(Context.current(), (Object)request, setter);
                this.client.execute(request.build()).aggregate().whenComplete((result, throwable) -> latch.countDown());
            });
        }
        latch.await();
        this.assertHighConcurrency(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void httpPipelining() throws InterruptedException {
        Assumptions.assumeTrue((boolean)this.options.testHttpPipelining);
        int count = 10;
        final CountDownLatch countDownLatch = new CountDownLatch(count);
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        TextMapPropagator propagator = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
        TextMapSetter setter = (request, key, value) -> request.headers().set(key, (Object)value);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = AbstractHttpServerTest.buildBootstrap(eventLoopGroup);
            Channel channel = bootstrap.connect(this.address.getHost(), this.port).sync().channel();
            channel.pipeline().addLast(new SimpleChannelInboundHandler<HttpObject>(){

                @Override
                protected void channelRead0(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
                    if (httpObject instanceof DefaultHttpResponse) {
                        countDownLatch.countDown();
                    }
                }
            });
            int i = 0;
            while (i < count) {
                int index = i++;
                String target = endpoint.resolvePath(this.address).getPath().toString() + "?" + "id" + "=" + index;
                this.testing.runWithSpan("client " + index, () -> {
                    Span.current().setAttribute("test.request.id", (long)index);
                    DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf("GET"), target, Unpooled.EMPTY_BUFFER);
                    request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(this.address.getHost() + ":" + this.port));
                    request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)"test-user-agent");
                    request.headers().set((CharSequence)HttpHeaderNames.X_FORWARDED_FOR, (Object)"1.1.1.1");
                    propagator.inject(Context.current(), (Object)request, setter);
                    channel.writeAndFlush(request);
                });
            }
            countDownLatch.await(30L, TimeUnit.SECONDS);
            this.assertHighConcurrency(count);
        }
        finally {
            eventLoopGroup.shutdownGracefully().await(10L, TimeUnit.SECONDS);
        }
    }

    private static Bootstrap buildBootstrap(EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)TimeUnit.SECONDS.toMillis(10L))).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) {
                ChannelPipeline pipeline = socketChannel.pipeline();
                pipeline.addLast(new HttpClientCodec());
            }
        });
        return bootstrap;
    }

    protected void assertHighConcurrency(int count) {
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        ArrayList<Consumer<TraceAssert>> assertions = new ArrayList<Consumer<TraceAssert>>();
        for (int i = 0; i < count; ++i) {
            assertions.add(trace -> {
                SpanData rootSpan = trace.getSpan(0);
                int requestId = Integer.parseInt(rootSpan.getName().substring("client ".length()));
                ArrayList<Consumer<SpanDataAssert>> spanAssertions = new ArrayList<Consumer<SpanDataAssert>>();
                spanAssertions.add(span -> span.hasName(rootSpan.getName()).hasKind(SpanKind.INTERNAL).hasNoParent().hasAttributesSatisfyingExactly(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)AttributeKey.longKey((String)"test.request.id"), (int)requestId)}));
                spanAssertions.add(span -> this.assertIndexedServerSpan((SpanDataAssert)span, requestId).hasParent(rootSpan));
                if (this.options.hasHandlerSpan.test(endpoint)) {
                    spanAssertions.add(span -> this.assertHandlerSpan((SpanDataAssert)span, "GET", endpoint).hasParent(trace.getSpan(1)));
                }
                int parentIndex = spanAssertions.size() - 2;
                if (this.options.hasHandlerAsControllerParentSpan.test(endpoint)) {
                    ++parentIndex;
                }
                int finalParentIndex = parentIndex;
                spanAssertions.add(span -> this.assertIndexedControllerSpan((SpanDataAssert)span, requestId).hasParent(trace.getSpan(finalParentIndex)));
                trace.hasSpansSatisfyingExactly(spanAssertions);
            });
        }
        this.testing.waitAndAssertTraces(assertions);
    }

    protected String assertResponseHasCustomizedHeaders(AggregatedHttpResponse response, ServerEndpoint endpoint, String expectedTraceId) {
        if (!this.options.hasResponseCustomizer.test(endpoint)) {
            return null;
        }
        String responseHeaderTraceId = response.headers().get("x-test-traceid");
        String responseHeaderSpanId = response.headers().get("x-test-spanid");
        if (expectedTraceId != null) {
            OpenTelemetryAssertions.assertThat((String)responseHeaderTraceId).matches((CharSequence)expectedTraceId);
        } else {
            OpenTelemetryAssertions.assertThat((String)responseHeaderTraceId).isNotNull();
        }
        OpenTelemetryAssertions.assertThat((String)responseHeaderSpanId).isNotNull();
        return responseHeaderSpanId;
    }

    protected void assertTheTraces(int size, String traceId, String parentId, String spanId, String method, ServerEndpoint endpoint, AggregatedHttpResponse response) {
        ArrayList<Consumer<TraceAssert>> assertions = new ArrayList<Consumer<TraceAssert>>();
        for (int i = 0; i < size; ++i) {
            assertions.add(trace -> {
                List spanData;
                int parentIndex;
                ArrayList<Consumer<SpanDataAssert>> spanAssertions = new ArrayList<Consumer<SpanDataAssert>>();
                spanAssertions.add(span -> {
                    this.assertServerSpan((SpanDataAssert)span, method, endpoint);
                    if (traceId != null) {
                        span.hasTraceId(traceId);
                    }
                    if (spanId != null) {
                        span.hasSpanId(spanId);
                    }
                    if (parentId != null) {
                        span.hasParentSpanId(parentId);
                    } else {
                        span.hasNoParent();
                    }
                });
                if (this.options.hasHandlerSpan.test(endpoint)) {
                    spanAssertions.add(span -> {
                        this.assertHandlerSpan((SpanDataAssert)span, method, endpoint);
                        span.hasParent(trace.getSpan(0));
                    });
                }
                if (endpoint != ServerEndpoint.NOT_FOUND) {
                    parentIndex = 0;
                    if (this.options.hasHandlerSpan.test(endpoint) && this.options.hasHandlerAsControllerParentSpan.test(endpoint)) {
                        parentIndex = spanAssertions.size() - 1;
                    }
                    int finalParentIndex = parentIndex;
                    spanAssertions.add(span -> {
                        this.assertControllerSpan((SpanDataAssert)span, endpoint == ServerEndpoint.EXCEPTION ? this.options.expectedException : null);
                        span.hasParent(trace.getSpan(finalParentIndex));
                    });
                }
                if (this.options.hasResponseSpan.test(endpoint)) {
                    parentIndex = spanAssertions.size() - 1;
                    spanAssertions.add(span -> {
                        this.assertResponseSpan((SpanDataAssert)span, method, endpoint);
                        span.hasParent(trace.getSpan(parentIndex));
                    });
                }
                if (this.options.hasErrorPageSpans.test(endpoint)) {
                    spanAssertions.addAll(this.errorPageSpanAssertions(method, endpoint));
                }
                trace.hasSpansSatisfyingExactly(spanAssertions);
                if (this.options.verifyServerSpanEndTime && (spanData = (List)AssertAccess.getActual(trace)).size() > 1) {
                    SpanData rootSpan = (SpanData)spanData.get(0);
                    for (int j = 1; j < spanData.size(); ++j) {
                        OpenTelemetryAssertions.assertThat((long)rootSpan.getEndEpochNanos()).isGreaterThanOrEqualTo(((SpanData)spanData.get(j)).getEndEpochNanos());
                    }
                }
            });
        }
        this.testing.waitAndAssertTraces(assertions);
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertControllerSpan(SpanDataAssert span, Throwable expectedException) {
        span.hasName("controller").hasKind(SpanKind.INTERNAL);
        if (expectedException != null) {
            span.hasStatus(StatusData.error());
            span.hasException(expectedException);
        }
        return span;
    }

    protected SpanDataAssert assertHandlerSpan(SpanDataAssert span, String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("assertHandlerSpan not implemented in " + this.getClass().getName());
    }

    protected SpanDataAssert assertResponseSpan(SpanDataAssert span, String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("assertResponseSpan not implemented in " + this.getClass().getName());
    }

    protected List<Consumer<SpanDataAssert>> errorPageSpanAssertions(String method, ServerEndpoint endpoint) {
        throw new UnsupportedOperationException("errorPageSpanAssertions not implemented in " + this.getClass().getName());
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertServerSpan(SpanDataAssert span, String method, ServerEndpoint endpoint) {
        Set<AttributeKey<?>> httpAttributes = this.options.httpAttributes.apply(endpoint);
        String expectedRoute = this.options.expectedHttpRoute.apply(endpoint);
        String name = this.getString(method, endpoint, expectedRoute);
        span.hasName(name).hasKind(SpanKind.SERVER);
        if (endpoint.status >= 500) {
            span.hasStatus(StatusData.error());
        }
        if (endpoint == ServerEndpoint.EXCEPTION && this.options.hasExceptionOnServerSpan.test(endpoint)) {
            span.hasException(this.options.expectedException);
        }
        span.hasAttributesSatisfying(attrs -> {
            AttributeKey httpResponseLengthKey;
            AttributeKey httpRequestLengthKey;
            AttributeKey netProtocolVersionKey;
            AttributeKey netSockHostAddrKey;
            AttributeKey netSockPeerAddrKey;
            AttributeKey netSockPeerPortKey;
            if (SemconvStability.emitOldHttpSemconv() && attrs.get(SemanticAttributes.NET_TRANSPORT) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(SemanticAttributes.NET_TRANSPORT, (Object)"ip_tcp");
            }
            if (SemconvStability.emitStableHttpSemconv() && attrs.get(NetworkAttributes.NETWORK_TRANSPORT) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(NetworkAttributes.NETWORK_TRANSPORT, (Object)"tcp");
            }
            if (SemconvStability.emitStableHttpSemconv() && attrs.get(NetworkAttributes.NETWORK_TYPE) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(NetworkAttributes.NETWORK_TYPE, (Object)"ipv4");
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_HOST_NAME), (Object)"localhost");
            AttributeKey netHostPortKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_HOST_PORT);
            if (attrs.get(netHostPortKey) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(netHostPortKey, this.port);
            }
            if (attrs.get(netSockPeerPortKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_SOCK_PEER_PORT)) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(netSockPeerPortKey, value -> ((AbstractLongAssert)OpenTelemetryAssertions.assertThat((Long)value).isInstanceOf(Long.class)).isNotEqualTo((Object)this.port));
            }
            if (attrs.get(netSockPeerAddrKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_SOCK_PEER_ADDR)) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(netSockPeerAddrKey, (Object)this.options.sockPeerAddr.apply(endpoint));
            }
            if (attrs.get(netSockHostAddrKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_SOCK_PEER_ADDR)) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(netSockHostAddrKey, (Object)"127.0.0.1");
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(AbstractHttpServerTest.getAttributeKey(SemanticAttributes.HTTP_CLIENT_IP), entry -> OpenTelemetryAssertions.assertThat((String)entry).satisfiesAnyOf(new ThrowingConsumer[]{value -> OpenTelemetryAssertions.assertThat((String)value).isNull(), value -> OpenTelemetryAssertions.assertThat((String)value).isEqualTo("1.1.1.1")}));
            if (SemconvStability.emitStableHttpSemconv() && attrs.get(NetworkAttributes.CLIENT_PORT) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(NetworkAttributes.CLIENT_PORT, port -> OpenTelemetryAssertions.assertThat((Long)port).isGreaterThan(0L));
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(AbstractHttpServerTest.getAttributeKey(SemanticAttributes.HTTP_METHOD), (Object)method);
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(AbstractHttpServerTest.getAttributeKey(SemanticAttributes.HTTP_STATUS_CODE), endpoint.status);
            AttributeKey netProtocolKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_PROTOCOL_NAME);
            if (attrs.get(netProtocolKey) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(netProtocolKey, (Object)"http");
            }
            if (attrs.get(netProtocolVersionKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.NET_PROTOCOL_VERSION)) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(netProtocolVersionKey, entry -> OpenTelemetryAssertions.assertThat((String)entry).isIn(new Object[]{"1.1", "2.0"}));
            }
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(SemanticAttributes.USER_AGENT_ORIGINAL, (Object)"test-user-agent");
            OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(AbstractHttpServerTest.getAttributeKey(SemanticAttributes.HTTP_SCHEME), (Object)"http");
            if (endpoint != ServerEndpoint.INDEXED_CHILD) {
                if (SemconvStability.emitOldHttpSemconv()) {
                    OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(SemanticAttributes.HTTP_TARGET, (Object)(endpoint.resolvePath(this.address).getPath() + (endpoint.getQuery() != null ? "?" + endpoint.getQuery() : "")));
                }
                if (SemconvStability.emitStableHttpSemconv()) {
                    OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(UrlAttributes.URL_PATH, (Object)endpoint.resolvePath(this.address).getPath());
                    if (endpoint.getQuery() != null) {
                        OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(UrlAttributes.URL_QUERY, (Object)endpoint.getQuery());
                    }
                }
            }
            if (attrs.get(httpRequestLengthKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH)) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(httpRequestLengthKey, entry -> OpenTelemetryAssertions.assertThat((Long)entry).isNotNegative());
            }
            if (attrs.get(httpResponseLengthKey = AbstractHttpServerTest.getAttributeKey(SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH)) != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).hasEntrySatisfying(httpResponseLengthKey, entry -> OpenTelemetryAssertions.assertThat((Long)entry).isNotNegative());
            }
            if (httpAttributes.contains(SemanticAttributes.HTTP_ROUTE) && expectedRoute != null) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry(SemanticAttributes.HTTP_ROUTE, (Object)expectedRoute);
            }
            if (endpoint == ServerEndpoint.CAPTURE_HEADERS) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry("http.request.header.x_test_request", new String[]{"test"});
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry("http.response.header.x_test_response", new String[]{"test"});
            }
            if (endpoint == ServerEndpoint.CAPTURE_PARAMETERS) {
                OpenTelemetryAssertions.assertThat((Attributes)attrs).containsEntry("servlet.request.parameter.test_parameter", new String[]{"test value \u00f5\u00e4\u00f6\u00fc"});
            }
        });
        return span;
    }

    protected static <T> AttributeKey<T> getAttributeKey(AttributeKey<T> oldKey) {
        return SemconvStabilityUtil.getAttributeKey(oldKey);
    }

    private String getString(String method, ServerEndpoint endpoint, String expectedRoute) {
        String name = this.options.expectedServerSpanNameMapper.apply(endpoint, method, expectedRoute);
        return name;
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertIndexedServerSpan(SpanDataAssert span, int requestId) {
        ServerEndpoint endpoint = ServerEndpoint.INDEXED_CHILD;
        String method = "GET";
        this.assertServerSpan(span, method, endpoint);
        if (SemconvStability.emitOldHttpSemconv()) {
            span.hasAttributesSatisfying(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)SemanticAttributes.HTTP_TARGET, (Object)(endpoint.resolvePath(this.address).getPath() + "?id=" + requestId))});
        }
        if (SemconvStability.emitStableHttpSemconv()) {
            span.hasAttributesSatisfying(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)UrlAttributes.URL_PATH, (Object)endpoint.resolvePath(this.address).getPath())});
            span.hasAttributesSatisfying(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)UrlAttributes.URL_QUERY, (Object)("id=" + requestId))});
        }
        return span;
    }

    @CanIgnoreReturnValue
    protected SpanDataAssert assertIndexedControllerSpan(SpanDataAssert span, int requestId) {
        span.hasName("controller").hasKind(SpanKind.INTERNAL).hasAttributesSatisfyingExactly(new AttributeAssertion[]{OpenTelemetryAssertions.equalTo((AttributeKey)AttributeKey.longKey((String)"test.request.id"), (int)requestId)});
        return span;
    }

    public String expectedServerSpanName(ServerEndpoint endpoint, String method, @Nullable String route) {
        return HttpServerTestOptions.DEFAULT_EXPECTED_SERVER_SPAN_NAME_MAPPER.apply(endpoint, method, route);
    }

    public String expectedHttpRoute(ServerEndpoint endpoint) {
        if (!this.options.httpAttributes.apply(endpoint).contains(SemanticAttributes.HTTP_ROUTE)) {
            return null;
        }
        if (ServerEndpoint.NOT_FOUND.equals(endpoint)) {
            return null;
        }
        if (ServerEndpoint.PATH_PARAM.equals(endpoint)) {
            return this.options.contextPath + "/path/:id/param";
        }
        return endpoint.resolvePath(this.address).getPath();
    }
}

