/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryLogRecordExporter;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricExporter;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class LibraryTestRunner
extends InstrumentationTestRunner {
    private static final OpenTelemetrySdk openTelemetry;
    private static final InMemorySpanExporter testSpanExporter;
    private static final InMemoryMetricExporter testMetricExporter;
    private static final InMemoryLogRecordExporter testLogRecordExporter;
    private static final MetricReader metricReader;
    private static boolean forceFlushCalled;
    private static final LibraryTestRunner INSTANCE;

    public static LibraryTestRunner instance() {
        return INSTANCE;
    }

    private LibraryTestRunner() {
        super((OpenTelemetry)openTelemetry);
    }

    @Override
    public void beforeTestClass() {
        if (GlobalOpenTelemetry.get() != openTelemetry) {
            GlobalOpenTelemetry.resetForTest();
            GlobalOpenTelemetry.set((OpenTelemetry)openTelemetry);
        }
    }

    @Override
    public void afterTestClass() {
    }

    @Override
    public void clearAllExportedData() {
        openTelemetry.getSdkMeterProvider().forceFlush().join(10L, TimeUnit.SECONDS);
        testSpanExporter.reset();
        testMetricExporter.reset();
        testLogRecordExporter.reset();
        forceFlushCalled = false;
    }

    @Override
    public OpenTelemetry getOpenTelemetry() {
        return openTelemetry;
    }

    public OpenTelemetrySdk getOpenTelemetrySdk() {
        return openTelemetry;
    }

    @Override
    public List<SpanData> getExportedSpans() {
        return testSpanExporter.getFinishedSpanItems();
    }

    @Override
    public List<MetricData> getExportedMetrics() {
        metricReader.forceFlush().join(10L, TimeUnit.SECONDS);
        return testMetricExporter.getFinishedMetricItems();
    }

    @Override
    public List<LogRecordData> getExportedLogRecords() {
        return testLogRecordExporter.getFinishedLogRecordItems();
    }

    @Override
    public boolean forceFlushCalled() {
        return forceFlushCalled;
    }

    static {
        GlobalOpenTelemetry.resetForTest();
        testSpanExporter = InMemorySpanExporter.create();
        testMetricExporter = InMemoryMetricExporter.create((AggregationTemporality)AggregationTemporality.DELTA);
        testLogRecordExporter = InMemoryLogRecordExporter.create();
        metricReader = PeriodicMetricReader.builder((MetricExporter)testMetricExporter).setInterval(Duration.ofNanos(Long.MAX_VALUE)).build();
        openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)new FlushTrackingSpanProcessor()).addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create())).addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)testSpanExporter)).build()).setMeterProvider(SdkMeterProvider.builder().registerMetricReader(metricReader).build()).setLoggerProvider(SdkLoggerProvider.builder().addLogRecordProcessor(SimpleLogRecordProcessor.create((LogRecordExporter)testLogRecordExporter)).build()).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).buildAndRegisterGlobal();
        INSTANCE = new LibraryTestRunner();
    }

    private static class FlushTrackingSpanProcessor
    implements SpanProcessor {
        private FlushTrackingSpanProcessor() {
        }

        public void onStart(Context parentContext, ReadWriteSpan span) {
        }

        public boolean isStartRequired() {
            return false;
        }

        public void onEnd(ReadableSpan span) {
        }

        public boolean isEndRequired() {
            return false;
        }

        public CompletableResultCode forceFlush() {
            forceFlushCalled = true;
            return CompletableResultCode.ofSuccess();
        }
    }
}

