/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.testing.TestInstrumenters;
import io.opentelemetry.instrumentation.testing.util.TelemetryDataUtil;
import io.opentelemetry.instrumentation.testing.util.ThrowingRunnable;
import io.opentelemetry.instrumentation.testing.util.ThrowingSupplier;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.testing.assertj.MetricAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.sdk.testing.assertj.TraceAssert;
import io.opentelemetry.sdk.testing.assertj.TracesAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public abstract class InstrumentationTestRunner {
    private final TestInstrumenters testInstrumenters;

    protected InstrumentationTestRunner(OpenTelemetry openTelemetry) {
        this.testInstrumenters = new TestInstrumenters(openTelemetry);
    }

    public abstract void beforeTestClass();

    public abstract void afterTestClass();

    public abstract void clearAllExportedData();

    public abstract OpenTelemetry getOpenTelemetry();

    public abstract List<SpanData> getExportedSpans();

    public abstract List<MetricData> getExportedMetrics();

    public abstract List<LogRecordData> getExportedLogRecords();

    public abstract boolean forceFlushCalled();

    public final List<List<SpanData>> traces() {
        return TelemetryDataUtil.groupTraces(this.getExportedSpans());
    }

    public final List<List<SpanData>> waitForTraces(int numberOfTraces) {
        try {
            return TelemetryDataUtil.waitForTraces(this::getExportedSpans, numberOfTraces, 20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new AssertionError("Error waiting for " + numberOfTraces + " traces", e);
        }
    }

    @SafeVarargs
    public final void waitAndAssertSortedTraces(Comparator<List<SpanData>> traceComparator, Consumer<TraceAssert> ... assertions) {
        this.waitAndAssertTraces(traceComparator, Arrays.asList(assertions), true);
    }

    public final void waitAndAssertSortedTraces(Comparator<List<SpanData>> traceComparator, Iterable<? extends Consumer<TraceAssert>> assertions) {
        this.waitAndAssertTraces(traceComparator, assertions, true);
    }

    @SafeVarargs
    public final void waitAndAssertTracesWithoutScopeVersionVerification(Consumer<TraceAssert> ... assertions) {
        this.waitAndAssertTracesWithoutScopeVersionVerification(Arrays.asList(assertions));
    }

    public final <T extends Consumer<TraceAssert>> void waitAndAssertTracesWithoutScopeVersionVerification(Iterable<T> assertions) {
        this.waitAndAssertTraces(null, assertions, false);
    }

    @SafeVarargs
    public final void waitAndAssertTraces(Consumer<TraceAssert> ... assertions) {
        this.waitAndAssertTraces(Arrays.asList(assertions));
    }

    public final <T extends Consumer<TraceAssert>> void waitAndAssertTraces(Iterable<T> assertions) {
        this.waitAndAssertTraces(null, assertions, true);
    }

    private <T extends Consumer<TraceAssert>> void waitAndAssertTraces(@Nullable Comparator<List<SpanData>> traceComparator, Iterable<T> assertions, boolean verifyScopeVersion) {
        ArrayList assertionsList = new ArrayList();
        assertions.forEach(assertionsList::add);
        try {
            Awaitility.await().untilAsserted(() -> this.doAssertTraces(traceComparator, assertionsList, verifyScopeVersion));
        }
        catch (ConditionTimeoutException e) {
            this.doAssertTraces(traceComparator, assertionsList, verifyScopeVersion);
        }
    }

    private <T extends Consumer<TraceAssert>> void doAssertTraces(@Nullable Comparator<List<SpanData>> traceComparator, List<T> assertionsList, boolean verifyScopeVersion) {
        List<List<SpanData>> traces = this.waitForTraces(assertionsList.size());
        if (verifyScopeVersion) {
            TelemetryDataUtil.assertScopeVersion(traces);
        }
        if (traceComparator != null) {
            traces.sort(traceComparator);
        }
        TracesAssert.assertThat(traces).hasTracesSatisfyingExactly(assertionsList);
    }

    public final void waitAndAssertMetrics(String instrumentationName, String metricName, Consumer<ListAssert<MetricData>> assertion) {
        Awaitility.await().untilAsserted(() -> assertion.accept((ListAssert)Assertions.assertThat(this.getExportedMetrics()).filteredOn(data -> data.getInstrumentationScopeInfo().getName().equals(instrumentationName) && data.getName().equals(metricName))));
    }

    @SafeVarargs
    public final void waitAndAssertMetrics(String instrumentationName, Consumer<MetricAssert> ... assertions) {
        Awaitility.await().untilAsserted(() -> {
            List<MetricData> metrics = this.instrumentationMetrics(instrumentationName);
            Assertions.assertThat(metrics).isNotEmpty();
            for (Consumer assertion : assertions) {
                Assertions.assertThat(metrics).anySatisfy(metric -> assertion.accept(OpenTelemetryAssertions.assertThat((MetricData)metric)));
            }
        });
    }

    private List<MetricData> instrumentationMetrics(String instrumentationName) {
        return this.getExportedMetrics().stream().filter(m -> m.getInstrumentationScopeInfo().getName().equals(instrumentationName)).collect(Collectors.toList());
    }

    public final <E extends Exception> void runWithSpan(String spanName, ThrowingRunnable<E> callback) throws E {
        this.runWithSpan(spanName, () -> {
            callback.run();
            return null;
        });
    }

    public final <T, E extends Throwable> T runWithSpan(String spanName, ThrowingSupplier<T, E> callback) throws E {
        return this.testInstrumenters.runWithSpan(spanName, callback);
    }

    public final <E extends Throwable> void runWithHttpClientSpan(String spanName, ThrowingRunnable<E> callback) throws E {
        this.runWithHttpClientSpan(spanName, () -> {
            callback.run();
            return null;
        });
    }

    public final <T, E extends Throwable> T runWithHttpClientSpan(String spanName, ThrowingSupplier<T, E> callback) throws E {
        return this.testInstrumenters.runWithHttpClientSpan(spanName, callback);
    }

    public final <E extends Throwable> void runWithHttpServerSpan(ThrowingRunnable<E> callback) throws E {
        this.runWithHttpServerSpan(() -> {
            callback.run();
            return null;
        });
    }

    public final <T, E extends Throwable> T runWithHttpServerSpan(ThrowingSupplier<T, E> callback) throws E {
        return this.testInstrumenters.runWithHttpServerSpan(callback);
    }

    public final <T, E extends Throwable> T runWithNonRecordingSpan(ThrowingSupplier<T, E> callback) throws E {
        return this.testInstrumenters.runWithNonRecordingSpan(callback);
    }
}

