/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing;

import ch.qos.logback.classic.Level;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.test.utils.LoggerUtils;
import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.javaagent.testing.common.AgentTestingExporterAccess;
import io.opentelemetry.javaagent.testing.common.TestAgentListenerAccess;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import org.slf4j.LoggerFactory;

public final class AgentTestRunner
extends InstrumentationTestRunner {
    private static final AgentTestRunner INSTANCE;

    public static InstrumentationTestRunner instance() {
        return INSTANCE;
    }

    private AgentTestRunner() {
        super(GlobalOpenTelemetry.get());
    }

    @Override
    public void beforeTestClass() {
        TestAgentListenerAccess.reset();
    }

    @Override
    public void afterTestClass() {
        assert (TestAgentListenerAccess.getInstrumentationErrorCount() == 0) : TestAgentListenerAccess.getInstrumentationErrorCount() + " Instrumentation errors during test";
        int muzzleFailureCount = TestAgentListenerAccess.getAndResetMuzzleFailureCount();
        assert (muzzleFailureCount == 0) : muzzleFailureCount + " Muzzle failures during test";
        assert (TestAgentListenerAccess.getIgnoredButTransformedClassNames().isEmpty()) : "Transformed classes match global libraries ignore matcher: " + TestAgentListenerAccess.getIgnoredButTransformedClassNames();
    }

    @Override
    public void clearAllExportedData() {
        AgentTestingExporterAccess.reset();
    }

    @Override
    public OpenTelemetry getOpenTelemetry() {
        return GlobalOpenTelemetry.get();
    }

    @Override
    public List<SpanData> getExportedSpans() {
        return AgentTestingExporterAccess.getExportedSpans();
    }

    @Override
    public List<MetricData> getExportedMetrics() {
        return AgentTestingExporterAccess.getExportedMetrics();
    }

    @Override
    public List<LogRecordData> getExportedLogRecords() {
        return AgentTestingExporterAccess.getExportedLogRecords();
    }

    @Override
    public boolean forceFlushCalled() {
        return AgentTestingExporterAccess.forceFlushCalled();
    }

    static {
        try {
            LoggerUtils.setLevel(LoggerFactory.getLogger((String)"ROOT"), Level.WARN);
            LoggerUtils.setLevel(LoggerFactory.getLogger((String)"io.opentelemetry"), Level.DEBUG);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        INSTANCE = new AgentTestRunner();
    }
}

