/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public final class ClasspathUtils {
    public static byte[] convertToByteArray(InputStream resource) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((bytesRead = resource.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static byte[] convertToByteArray(Class<?> clazz) throws IOException {
        try (InputStream inputStream = clazz.getClassLoader().getResourceAsStream(ClasspathUtils.getResourceName(clazz.getName()));){
            byte[] byArray = ClasspathUtils.convertToByteArray(inputStream);
            return byArray;
        }
    }

    public static URL createJarWithClasses(ClassLoader loader, String ... resourceNames) throws IOException {
        File tmpJar = File.createTempFile(UUID.randomUUID() + "", ".jar");
        tmpJar.deleteOnExit();
        Manifest manifest = new Manifest();
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(tmpJar), manifest);
        for (String resourceName : resourceNames) {
            try (InputStream is = loader.getResourceAsStream(resourceName);){
                ClasspathUtils.addToJar(resourceName, ClasspathUtils.convertToByteArray(is), target);
            }
        }
        target.close();
        return tmpJar.toURI().toURL();
    }

    public static URL createJarWithClasses(Class<?> ... classes) throws IOException {
        File tmpJar = File.createTempFile(UUID.randomUUID() + "", ".jar");
        tmpJar.deleteOnExit();
        Manifest manifest = new Manifest();
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(tmpJar), manifest);
        for (Class<?> clazz : classes) {
            ClasspathUtils.addToJar(ClasspathUtils.getResourceName(clazz.getName()), ClasspathUtils.convertToByteArray(clazz), target);
        }
        target.close();
        return tmpJar.toURI().toURL();
    }

    private static void addToJar(String resourceName, byte[] bytes, JarOutputStream jarOutputStream) throws IOException {
        JarEntry entry = new JarEntry(resourceName);
        jarOutputStream.putNextEntry(entry);
        jarOutputStream.write(bytes, 0, bytes.length);
        jarOutputStream.closeEntry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isClassLoaded(String className, ClassLoader classLoader) {
        try {
            Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            try {
                findLoadedClassMethod.setAccessible(true);
                Class loadedClass = (Class)findLoadedClassMethod.invoke((Object)classLoader, className);
                boolean bl = null != loadedClass && loadedClass.getClassLoader() == classLoader;
                return bl;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                findLoadedClassMethod.setAccessible(false);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getResourceName(String className) {
        if (!className.endsWith(".class")) {
            return className.replace('.', '/') + ".class";
        }
        return className;
    }

    private ClasspathUtils() {
    }
}

