/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.asserts;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.instrumentation.test.asserts.AttributesAssert;
import io.opentelemetry.instrumentation.test.asserts.EventAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.SemanticAttributes;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class SpanAssert
implements GroovyObject {
    private final SpanData span;
    private final Object checked;
    private final Set<Integer> assertedEventIndexes;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private SpanAssert(Object span) {
        MetaClass metaClass;
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.checked = map;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, HashSet.class);
        this.assertedEventIndexes = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = span;
        this.span = IndyInterface.bootstrap("cast", "()", 0, object);
    }

    public static void assertSpan(SpanData span, @ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.SpanAssert"}) @DelegatesTo(strategy=1, value=SpanAssert.class) Closure spec) {
        CallSite asserter = IndyInterface.bootstrap("init", "<init>", 0, SpanAssert.class, span);
        IndyInterface.bootstrap("invoke", "assertSpan", 0, asserter, spec);
        IndyInterface.bootstrap("invoke", "assertEventsAllVerified", 0, asserter);
    }

    public void assertSpan(@ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.SpanAssert"}) @DelegatesTo(strategy=1, value=SpanAssert.class) Closure spec) {
        CallSite clone = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, spec));
        SpanAssert spanAssert = this;
        ScriptBytecodeAdapter.setProperty((Object)spanAssert, null, (Object)clone, (String)"delegate");
        CallSite callSite = IndyInterface.bootstrap("getProperty", "DELEGATE_FIRST", 0, Closure.class);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)clone, (String)"resolveStrategy");
        IndyInterface.bootstrap("invoke", "call", 0, clone, this);
        IndyInterface.bootstrap("invoke", "assertDefaults", 2, this);
    }

    public void events(int expectedCount) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "totalRecordedEvents", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            int n = expectedCount;
            valueRecorder.record((Object)n, 36);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)n);
            valueRecorder.record((Object)bl, 33);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.totalRecordedEvents == expectedCount", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder2.record((Object)spanData, 8);
            valueRecorder2.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "events", 0, spanData);
            valueRecorder2.record((Object)callSite, 13);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "size", 0, callSite);
            valueRecorder2.record((Object)callSite2, 20);
            int n = expectedCount;
            valueRecorder2.record((Object)n, 30);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite2, (Object)n);
            valueRecorder2.record((Object)bl, 27);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.events.size() == expectedCount", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    public void event(int index, @ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.EventAssert"}) @DelegatesTo(strategy=1, value=EventAssert.class) Closure spec) {
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)index, (Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "events", 0, this.span)))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, ArrayIndexOutOfBoundsException.class, index));
        }
        IndyInterface.bootstrap("invoke", "add", 0, this.assertedEventIndexes, index);
        IndyInterface.bootstrap("invoke", "assertEvent", 0, EventAssert.class, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "events", 0, this.span), index), spec);
    }

    public Object name(String expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            String string = expected;
            valueRecorder.record((Object)string, 21);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)string);
            valueRecorder.record((Object)bl, 18);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.name == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"name");
        return bl;
    }

    public Object instrumentationLibraryVersion(String expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "instrumentationLibraryInfo", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "version", 0, callSite);
            valueRecorder.record((Object)callSite2, 40);
            String string = expected;
            valueRecorder.record((Object)string, 51);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite2, (Object)string);
            valueRecorder.record((Object)bl, 48);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.instrumentationLibraryInfo.version == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"instrumentationLibraryVersion");
        return bl;
    }

    public Object name(Pattern expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            Pattern pattern = expected;
            valueRecorder.record((Object)pattern, 21);
            Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)callSite, (Object)pattern);
            valueRecorder.record((Object)matcher, 18);
            if (IndyInterface.bootstrap("cast", "()", 0, matcher) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.name =~ expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"name");
        return bl;
    }

    public Object name(Closure expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Closure closure = expected;
            valueRecorder.record((Object)closure, 19);
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 34);
            valueRecorder.record((Object)spanData, 34);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 0, spanData);
            valueRecorder.record((Object)callSite, 39);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "call", 0, closure, callSite);
            valueRecorder.record((Object)callSite2, 29);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert ((Closure) expected).call(span.name)", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"name");
        return bl;
    }

    public Object nameContains(String ... expectedParts) {
        CallSite expectedPart = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, expectedParts));
        if (callSite != null) {
            while (callSite.hasNext()) {
                expectedPart = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                ValueRecorder valueRecorder = new ValueRecorder();
                try {
                    SpanData spanData = this.span;
                    valueRecorder.record((Object)spanData, 8);
                    valueRecorder.record((Object)spanData, 8);
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "name", 0, spanData);
                    valueRecorder.record((Object)callSite2, 13);
                    CallSite callSite3 = expectedPart;
                    valueRecorder.record((Object)callSite3, 27);
                    CallSite callSite4 = IndyInterface.bootstrap("invoke", "contains", 0, callSite2, callSite3);
                    valueRecorder.record((Object)callSite4, 18);
                    if (IndyInterface.bootstrap("cast", "()", 0, callSite4) != false) {
                        valueRecorder.clear();
                        continue;
                    }
                    throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.name.contains(expectedPart)", (ValueRecorder)valueRecorder), null);
                }
                catch (Throwable throwable) {
                    valueRecorder.clear();
                    throw throwable;
                }
            }
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"name");
        return bl;
    }

    public Object kind(SpanKind expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "kind", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            SpanKind spanKind = expected;
            valueRecorder.record((Object)spanKind, 21);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)spanKind);
            valueRecorder.record((Object)bl, 18);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.kind == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"kind");
        return bl;
    }

    public Object hasNoParent() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 24);
            valueRecorder.record((Object)spanData, 24);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "parentSpanId", 0, spanData);
            valueRecorder.record((Object)callSite, 29);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "isValid", 0, SpanId.class, callSite);
            valueRecorder.record((Object)callSite2, 16);
            boolean bl = IndyInterface.bootstrap("cast", "()", 0, callSite2) == false;
            valueRecorder.record((Object)bl, 8);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert !SpanId.isValid(span.parentSpanId)", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"parentSpanId");
        return bl;
    }

    public Object parentSpanId(String expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "parentSpanId", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            String string = expected;
            valueRecorder.record((Object)string, 29);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)string);
            valueRecorder.record((Object)bl, 26);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.parentSpanId == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"parentId");
        return bl;
    }

    public Object spanId(String expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "spanId", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            String string = expected;
            valueRecorder.record((Object)string, 23);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)string);
            valueRecorder.record((Object)bl, 20);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.spanId == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"spanId");
        return bl;
    }

    public Object traceId(String expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "traceId", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            String string = expected;
            valueRecorder.record((Object)string, 24);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)string);
            valueRecorder.record((Object)bl, 21);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.traceId == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"traceId");
        return bl;
    }

    public Object childOf(SpanData expectedParent) {
        IndyInterface.bootstrap("invoke", "parentSpanId", 2, this, IndyInterface.bootstrap("getProperty", "spanId", 0, expectedParent));
        return IndyInterface.bootstrap("invoke", "traceId", 2, this, IndyInterface.bootstrap("getProperty", "traceId", 0, expectedParent));
    }

    public Object hasLink(SpanData expectedLink) {
        return IndyInterface.bootstrap("invoke", "hasLink", 2, this, IndyInterface.bootstrap("getProperty", "traceId", 0, expectedLink), IndyInterface.bootstrap("getProperty", "spanId", 0, expectedLink));
    }

    public Object hasLink(String expectedTraceId, String expectedSpanId) {
        Boolean found = false;
        Object link = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "links", 0, this.span)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                link = callSite.next();
                if (!(ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "traceId", 0, IndyInterface.bootstrap("getProperty", "spanContext", 0, link)), (Object)expectedTraceId) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "spanId", 0, IndyInterface.bootstrap("getProperty", "spanContext", 0, link)), (Object)expectedSpanId))) continue;
                found = true;
                break;
            }
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Boolean bl = found;
            valueRecorder.record((Object)bl, 8);
            if (IndyInterface.bootstrap("cast", "()", 0, bl) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert found", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return null;
    }

    public Object hasNoLinks() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "links", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "empty", 0, callSite);
            valueRecorder.record((Object)callSite2, 19);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.links.empty", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return null;
    }

    public Object status(StatusCode expected) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 8);
            valueRecorder.record((Object)spanData, 8);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "status", 0, spanData);
            valueRecorder.record((Object)callSite, 13);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "statusCode", 0, callSite);
            valueRecorder.record((Object)callSite2, 20);
            StatusCode statusCode = expected;
            valueRecorder.record((Object)statusCode, 34);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite2, (Object)statusCode);
            valueRecorder.record((Object)bl, 31);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert span.status.statusCode == expected", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.checked, (String)"status");
        return bl;
    }

    public Object errorEvent(Class<Throwable> expectedClass) {
        return IndyInterface.bootstrap("invoke", "errorEvent", 2, this, expectedClass, null);
    }

    public Object errorEventWithAnyMessage(Class<Throwable> expectedClass) {
        Reference expectedClass2 = new Reference(expectedClass);
        public final class _errorEventWithAnyMessage_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference expectedClass;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _errorEventWithAnyMessage_closure1(Object _outerInstance, Object _thisObject, Reference expectedClass) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.expectedClass = reference = expectedClass;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "eventName", 2, this, IndyInterface.bootstrap("getProperty", "EXCEPTION_EVENT_NAME", 0, SemanticAttributes.class));
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference expectedClass;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject, Reference expectedClass) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.expectedClass = reference = expectedClass;
                    }

                    public Object doCall(Object it) {
                        ScriptBytecodeAdapter.invokeMethodOnCurrentN(_closure4.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "EXCEPTION_TYPE", 0, SemanticAttributes.class)}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("getProperty", "canonicalName", 0, IndyInterface.bootstrap("cast", "()", 0, this.expectedClass.get()))});
                        ScriptBytecodeAdapter.invokeMethodOnCurrentN(_closure4.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "EXCEPTION_STACKTRACE", 0, SemanticAttributes.class)}, new String[]{"", ""}))), (Object[])new Object[]{String.class});
                        public final class _closure5
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure5(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return ScriptBytecodeAdapter.compareNotEqual((Object)it, null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure5.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(_closure4.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "EXCEPTION_MESSAGE", 0, SemanticAttributes.class)}, new String[]{"", ""}))), (Object[])new Object[]{new _closure5((Object)this, this.getThisObject())});
                    }

                    @Generated
                    public Class getExpectedClass() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.expectedClass.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "attributes", 2, this, new _closure4((Object)this, this.getThisObject(), this.expectedClass));
            }

            @Generated
            public Class getExpectedClass() {
                return IndyInterface.bootstrap("cast", "()", 0, this.expectedClass.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _errorEventWithAnyMessage_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "event", 2, this, false, new _errorEventWithAnyMessage_closure1(this, this, expectedClass2));
    }

    public Object errorEvent(Class<Throwable> expectedClass, Object expectedMessage) {
        return IndyInterface.bootstrap("invoke", "errorEvent", 2, this, expectedClass, expectedMessage, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object errorEvent(Class<Throwable> errorClass, Object expectedMessage, int index) {
        void var2_2;
        Reference errorClass2 = new Reference(errorClass);
        Reference expectedMessage2 = new Reference((Object)var2_2);
        public final class _errorEvent_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference errorClass;
            private /* synthetic */ Reference expectedMessage;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _errorEvent_closure2(Object _outerInstance, Object _thisObject, Reference errorClass, Reference expectedMessage) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.errorClass = reference2 = errorClass;
                this.expectedMessage = reference = expectedMessage;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "eventName", 2, this, IndyInterface.bootstrap("getProperty", "EXCEPTION_EVENT_NAME", 0, SemanticAttributes.class));
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference errorClass;
                    private /* synthetic */ Reference expectedMessage;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference errorClass, Reference expectedMessage) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.errorClass = reference2 = errorClass;
                        this.expectedMessage = reference = expectedMessage;
                    }

                    public Object doCall(Object it) {
                        ScriptBytecodeAdapter.invokeMethodOnCurrentN(_closure6.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "EXCEPTION_TYPE", 0, SemanticAttributes.class)}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("getProperty", "canonicalName", 0, IndyInterface.bootstrap("cast", "()", 0, this.errorClass.get()))});
                        ScriptBytecodeAdapter.invokeMethodOnCurrentN(_closure6.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "EXCEPTION_STACKTRACE", 0, SemanticAttributes.class)}, new String[]{"", ""}))), (Object[])new Object[]{String.class});
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.expectedMessage.get(), null)) {
                            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(_closure6.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "EXCEPTION_MESSAGE", 0, SemanticAttributes.class)}, new String[]{"", ""}))), (Object[])new Object[]{this.expectedMessage.get()});
                        }
                        return null;
                    }

                    @Generated
                    public Class getErrorClass() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.errorClass.get());
                    }

                    @Generated
                    public Object getExpectedMessage() {
                        return this.expectedMessage.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "attributes", 2, this, new _closure6((Object)this, this.getThisObject(), this.errorClass, this.expectedMessage));
            }

            @Generated
            public Class getErrorClass() {
                return IndyInterface.bootstrap("cast", "()", 0, this.errorClass.get());
            }

            @Generated
            public Object getExpectedMessage() {
                return this.expectedMessage.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _errorEvent_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "event", 2, this, index, new _errorEvent_closure2(this, this, errorClass2, expectedMessage2));
    }

    public void assertDefaults() {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "status", 0, this.checked)) == false) {
            IndyInterface.bootstrap("invoke", "status", 2, this, IndyInterface.bootstrap("getProperty", "UNSET", 0, StatusCode.class));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "kind", 0, this.checked)) == false) {
            IndyInterface.bootstrap("invoke", "kind", 2, this, IndyInterface.bootstrap("getProperty", "INTERNAL", 0, SpanKind.class));
        }
    }

    public void attributes(@ClosureParams(value=SimpleType.class, options={"io.opentelemetry.instrumentation.test.asserts.AttributesAssert"}) @DelegatesTo(strategy=1, value=AttributesAssert.class) Closure spec) {
        IndyInterface.bootstrap("invoke", "assertAttributes", 0, AttributesAssert.class, IndyInterface.bootstrap("invoke", "toMap", 2, this, IndyInterface.bootstrap("getProperty", "attributes", 0, this.span)), spec);
    }

    public void assertEventsAllVerified() {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Set<Integer> set = this.assertedEventIndexes;
            valueRecorder.record(set, 8);
            valueRecorder.record(set, 8);
            CallSite callSite = IndyInterface.bootstrap("invoke", "size", 0, set);
            valueRecorder.record((Object)callSite, 29);
            SpanData spanData = this.span;
            valueRecorder.record((Object)spanData, 39);
            valueRecorder.record((Object)spanData, 39);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "events", 0, spanData);
            valueRecorder.record((Object)callSite2, 44);
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "size", 0, callSite2);
            valueRecorder.record((Object)callSite3, 51);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)callSite, (Object)callSite3);
            valueRecorder.record((Object)bl, 36);
            if (!bl) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert assertedEventIndexes.size() == span.events.size()", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    private Map<String, Object> toMap(Attributes attributes) {
        Reference map = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        public final class _toMap_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference map;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toMap_closure3(Object _outerInstance, Object _thisObject, Reference map) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.map = reference = map;
            }

            public Object doCall(Object key, Object value) {
                return IndyInterface.bootstrap("invoke", "put", 0, this.map.get(), IndyInterface.bootstrap("getProperty", "key", 0, key), value);
            }

            @Generated
            public Object call(Object key, Object value) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, key, value);
            }

            @Generated
            public Object getMap() {
                return this.map.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toMap_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "forEach", 0, attributes, new _toMap_closure3(this, this, map));
        return IndyInterface.bootstrap("cast", "()", 0, map.get());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SpanAssert.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

