/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import java.util.function.LongSupplier;

public final class DbConnectionPoolMetrics {
    static final AttributeKey<String> POOL_NAME = AttributeKey.stringKey("pool.name");
    static final AttributeKey<String> CONNECTION_STATE = AttributeKey.stringKey("state");
    static final String STATE_IDLE = "idle";
    static final String STATE_USED = "used";
    private final Meter meter;
    private final Attributes attributes;
    private final Attributes usedConnectionsAttributes;
    private final Attributes idleConnectionsAttributes;

    public static DbConnectionPoolMetrics create(OpenTelemetry openTelemetry, String instrumentationName, String poolName) {
        MeterBuilder meterBuilder = openTelemetry.getMeterProvider().meterBuilder(instrumentationName);
        String version = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
        if (version != null) {
            meterBuilder.setInstrumentationVersion(version);
        }
        return new DbConnectionPoolMetrics(meterBuilder.build(), Attributes.of(POOL_NAME, poolName));
    }

    DbConnectionPoolMetrics(Meter meter, Attributes attributes) {
        this.meter = meter;
        this.attributes = attributes;
        this.usedConnectionsAttributes = attributes.toBuilder().put(CONNECTION_STATE, STATE_USED).build();
        this.idleConnectionsAttributes = attributes.toBuilder().put(CONNECTION_STATE, STATE_IDLE).build();
    }

    public ObservableLongUpDownCounter usedConnections(LongSupplier usedConnectionsGetter) {
        return this.meter.upDownCounterBuilder("db.client.connections.usage").setUnit("connections").setDescription("The number of connections that are currently in state described by the state attribute.").buildWithCallback(measurement -> measurement.record(usedConnectionsGetter.getAsLong(), this.usedConnectionsAttributes));
    }

    public ObservableLongUpDownCounter idleConnections(LongSupplier idleConnectionsGetter) {
        return this.meter.upDownCounterBuilder("db.client.connections.usage").setUnit("connections").setDescription("The number of connections that are currently in state described by the state attribute.").buildWithCallback(measurement -> measurement.record(idleConnectionsGetter.getAsLong(), this.idleConnectionsAttributes));
    }

    public ObservableLongUpDownCounter minIdleConnections(LongSupplier minIdleConnectionsGetter) {
        return this.meter.upDownCounterBuilder("db.client.connections.idle.min").setUnit("connections").setDescription("The minimum number of idle open connections allowed.").buildWithCallback(measurement -> measurement.record(minIdleConnectionsGetter.getAsLong(), this.attributes));
    }

    public ObservableLongUpDownCounter maxIdleConnections(LongSupplier maxIdleConnectionsGetter) {
        return this.meter.upDownCounterBuilder("db.client.connections.idle.max").setUnit("connections").setDescription("The maximum number of idle open connections allowed.").buildWithCallback(measurement -> measurement.record(maxIdleConnectionsGetter.getAsLong(), this.attributes));
    }

    public ObservableLongUpDownCounter maxConnections(LongSupplier maxConnectionsGetter) {
        return this.meter.upDownCounterBuilder("db.client.connections.max").setUnit("connections").setDescription("The maximum number of open connections allowed.").buildWithCallback(measurement -> measurement.record(maxConnectionsGetter.getAsLong(), this.attributes));
    }

    public ObservableLongUpDownCounter pendingRequestsForConnection(LongSupplier pendingRequestsGetter) {
        return this.meter.upDownCounterBuilder("db.client.connections.pending_requests").setUnit("requests").setDescription("The number of pending requests for an open connection, cumulative for the entire pool.").buildWithCallback(measurement -> measurement.record(pendingRequestsGetter.getAsLong(), this.attributes));
    }

    public LongCounter connectionTimeouts() {
        return this.meter.counterBuilder("db.client.connections.timeouts").setUnit("timeouts").setDescription("The number of connection timeouts that have occurred trying to obtain a connection from the pool.").build();
    }

    public DoubleHistogram connectionCreateTime() {
        return this.meter.histogramBuilder("db.client.connections.create_time").setUnit("ms").setDescription("The time it took to create a new connection.").build();
    }

    public DoubleHistogram connectionWaitTime() {
        return this.meter.histogramBuilder("db.client.connections.wait_time").setUnit("ms").setDescription("The time it took to obtain an open connection from the pool.").build();
    }

    public DoubleHistogram connectionUseTime() {
        return this.meter.histogramBuilder("db.client.connections.use_time").setUnit("ms").setDescription("The time between borrowing a connection and returning it to the pool.").build();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }
}

