/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import java.util.Locale;
import javax.annotation.Nullable;

public final class ConfigPropertiesUtil {
    public static boolean getBoolean(String propertyName, boolean defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        return strValue == null ? defaultValue : Boolean.parseBoolean(strValue);
    }

    public static int getInt(String propertyName, int defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Nullable
    public static String getString(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        return System.getenv(ConfigPropertiesUtil.toEnvVarName(propertyName));
    }

    private static String toEnvVarName(String propertyName) {
        return propertyName.toUpperCase(Locale.ROOT).replace('-', '_').replace('.', '_');
    }

    private ConfigPropertiesUtil() {
    }
}

