/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

final class CapturedMessageHeadersUtil {
    private static final ConcurrentMap<String, AttributeKey<List<String>>> attributeKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();

    static List<String> lowercase(List<String> names) {
        return Collections.unmodifiableList(names.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
    }

    static AttributeKey<List<String>> attributeKey(String headerName) {
        return attributeKeysCache.computeIfAbsent(headerName, n -> CapturedMessageHeadersUtil.createKey(n));
    }

    private static AttributeKey<List<String>> createKey(String headerName) {
        String key = "messaging.header." + headerName.replace('-', '_');
        return AttributeKey.stringArrayKey(key);
    }

    private CapturedMessageHeadersUtil() {
    }
}

