/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class SslContextBuilderTest {
    @Test
    public void testClientContextFromFileJdk() throws Exception {
        SslContextBuilderTest.testClientContextFromFile(SslProvider.JDK);
    }

    @Test
    public void testClientContextFromFileOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        SslContextBuilderTest.testClientContextFromFile(SslProvider.OPENSSL);
    }

    @Test
    public void testClientContextJdk() throws Exception {
        SslContextBuilderTest.testClientContext(SslProvider.JDK);
    }

    @Test
    public void testClientContextOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        SslContextBuilderTest.testClientContext(SslProvider.OPENSSL);
    }

    @Test
    public void testCombinedPemFileClientContextJdk() throws Exception {
        this.testServerContextWithCombinedCertAndKeyInPem(SslProvider.JDK);
    }

    @Test
    public void testCombinedPemFileClientContextOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        this.testServerContextWithCombinedCertAndKeyInPem(SslProvider.OPENSSL);
    }

    @Test
    public void testKeyStoreTypeJdk() throws Exception {
        SslContextBuilderTest.testKeyStoreType(SslProvider.JDK);
    }

    @Test
    public void testKeyStoreTypeOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        SslContextBuilderTest.testKeyStoreType(SslProvider.OPENSSL);
    }

    @Test
    public void testServerContextFromFileJdk() throws Exception {
        SslContextBuilderTest.testServerContextFromFile(SslProvider.JDK);
    }

    @Test
    public void testServerContextFromFileOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        SslContextBuilderTest.testServerContextFromFile(SslProvider.OPENSSL);
    }

    @Test
    public void testServerContextJdk() throws Exception {
        SslContextBuilderTest.testServerContext(SslProvider.JDK);
    }

    @Test
    public void testServerContextOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        SslContextBuilderTest.testServerContext(SslProvider.OPENSSL);
    }

    @Test
    public void testContextFromManagersJdk() throws Exception {
        SslContextBuilderTest.testContextFromManagers(SslProvider.JDK);
    }

    @Test
    public void testContextFromManagersOpenssl() throws Exception {
        OpenSsl.ensureAvailability();
        Assumptions.assumeTrue((boolean)OpenSsl.useKeyManagerFactory());
        SslContextBuilderTest.testContextFromManagers(SslProvider.OPENSSL);
    }

    @Test
    public void testUnsupportedPrivateKeyFailsFastForServer() {
        Assumptions.assumeTrue((boolean)OpenSsl.isBoringSSL());
        SslContextBuilderTest.testUnsupportedPrivateKeyFailsFast(true);
    }

    @Test
    public void testUnsupportedPrivateKeyFailsFastForClient() {
        Assumptions.assumeTrue((boolean)OpenSsl.isBoringSSL());
        SslContextBuilderTest.testUnsupportedPrivateKeyFailsFast(false);
    }

    private static void testUnsupportedPrivateKeyFailsFast(boolean server) {
        SslContextBuilder builder;
        Assumptions.assumeTrue((boolean)OpenSsl.isBoringSSL());
        String cert = "-----BEGIN CERTIFICATE-----\nMIICODCCAY2gAwIBAgIEXKTrajAKBggqhkjOPQQDBDBUMQswCQYDVQQGEwJVUzEM\nMAoGA1UECAwDTi9hMQwwCgYDVQQHDANOL2ExDDAKBgNVBAoMA04vYTEMMAoGA1UE\nCwwDTi9hMQ0wCwYDVQQDDARUZXN0MB4XDTE5MDQwMzE3MjA0MloXDTIwMDQwMjE3\nMjA0MlowVDELMAkGA1UEBhMCVVMxDDAKBgNVBAgMA04vYTEMMAoGA1UEBwwDTi9h\nMQwwCgYDVQQKDANOL2ExDDAKBgNVBAsMA04vYTENMAsGA1UEAwwEVGVzdDCBpzAQ\nBgcqhkjOPQIBBgUrgQQAJwOBkgAEBPYWoTjlS2pCMGEM2P8qZnmURWA5e7XxPfIh\nHA876sjmgjJluPgT0OkweuxI4Y/XjzcPnnEBONgzAV1X93UmXdtRiIau/zvsAeFb\nj/q+6sfj1jdnUk6QsMx22kAwplXHmdz1z5ShXQ7mDZPxDbhCPEAUXzIzOqvWIZyA\nHgFxZXmQKEhExA8nxgSIvzQ3ucMwMAoGCCqGSM49BAMEA4GYADCBlAJIAdPD6jaN\nvGxkxcsIbcHn2gSfP1F1G8iNJYrXIN91KbQm8OEp4wxqnBwX8gb/3rmSoEhIU/te\nCcHuFs0guBjfgRWtJ/eDnKB/AkgDbkqrB5wqJFBmVd/rJ5QdwUVNuGP/vDjFVlb6\nEsny6//gTL7jYubLUKHOPIMftCZ2Jn4b+5l0kAs62HD5XkZLPDTwRbf7VCE=\n-----END CERTIFICATE-----";
        String key = "-----BEGIN PRIVATE KEY-----\nMIIBCQIBADAQBgcqhkjOPQIBBgUrgQQAJwSB8TCB7gIBAQRIALNClTXqQWWlYDHw\nLjNxXpLk17iPepkmablhbxmYX/8CNzoz1o2gcUidoIO2DM9hm7adI/W31EOmSiUJ\n+UsC/ZH3i2qr0wn+oAcGBSuBBAAnoYGVA4GSAAQE9hahOOVLakIwYQzY/ypmeZRF\nYDl7tfE98iEcDzvqyOaCMmW4+BPQ6TB67Ejhj9ePNw+ecQE42DMBXVf3dSZd21GI\nhq7/O+wB4VuP+r7qx+PWN2dSTpCwzHbaQDCmVceZ3PXPlKFdDuYNk/ENuEI8QBRf\nMjM6q9YhnIAeAXFleZAoSETEDyfGBIi/NDe5wzA=\n-----END PRIVATE KEY-----";
        ByteArrayInputStream certStream = new ByteArrayInputStream(cert.getBytes(CharsetUtil.US_ASCII));
        ByteArrayInputStream keyStream = new ByteArrayInputStream(key.getBytes(CharsetUtil.US_ASCII));
        try {
            builder = server ? SslContextBuilder.forServer((InputStream)certStream, (InputStream)keyStream, null) : SslContextBuilder.forClient().keyManager((InputStream)certStream, (InputStream)keyStream, null);
        }
        catch (IllegalArgumentException e) {
            Assumptions.assumeFalse(("Input stream not contain valid certificates.".equals(e.getMessage()) && e.getCause() != null && "java.io.IOException: Unknown named curve: 1.3.132.0.39".equals(e.getCause().getMessage()) ? 1 : 0) != 0, (String)"Cannot test that SslProvider rejects certificates with curve 1.3.132.0.39 because the key manager does not know the curve either.");
            throw e;
        }
        Assertions.assertThrows(SSLException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                builder.sslProvider(SslProvider.OPENSSL).build();
            }
        });
    }

    private void testServerContextWithCombinedCertAndKeyInPem(SslProvider provider) throws SSLException {
        String pem = "-----BEGIN CERTIFICATE-----\nMIIB1jCCAX0CCQDq4PSOirh7MDAJBgcqhkjOPQQBMHIxCzAJBgNVBAYTAlVTMQsw\nCQYDVQQIDAJDQTEMMAoGA1UEBwwDRm9vMQwwCgYDVQQKDANCYXIxDDAKBgNVBAsM\nA0JhejEQMA4GA1UEAwwHQmFyLmNvbTEaMBgGCSqGSIb3DQEJARYLZm9vQGJhci5j\nb20wHhcNMjIxMDAyMTYzODAyWhcNMjIxMjAxMTYzODAyWjB2MQswCQYDVQQGEwJV\nUzELMAkGA1UECAwCQ0ExDDAKBgNVBAcMA0ZvbzEMMAoGA1UECgwDQmFyMQwwCgYD\nVQQLDANiYXoxFDASBgNVBAMMC2Jhci5iYXIuYmF6MRowGAYJKoZIhvcNAQkBFgtm\nb29AYmFyLmNvbTBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABHiEmjPEqQbqXYMB\nnAPOv24rJf6MhTwHB0QC1suZ9q9XFUkalnqGryqf/emHs81RsXWKz4sCsbIJkmHz\nH8HYhmkwCQYHKoZIzj0EAQNIADBFAiBCgzxZ5qviemPdejt2WazSgwNJTbirzoQa\nFMv2XFTTCwIhANS3fZ8BulbYkdRWVEFwm2FGotqLfC60JA/gg/brlWSP\n-----END CERTIFICATE-----\n-----BEGIN EC PRIVATE KEY-----\nMHcCAQEEIF8RlaD0JX8u2Lryq1+AbYfDaTBPJnPSA8+N2L12YuuUoAoGCCqGSM49\nAwEHoUQDQgAEeISaM8SpBupdgwGcA86/bisl/oyFPAcHRALWy5n2r1cVSRqWeoav\nKp/96YezzVGxdYrPiwKxsgmSYfMfwdiGaQ==\n-----END EC PRIVATE KEY-----";
        ByteArrayInputStream certStream = new ByteArrayInputStream(pem.getBytes(CharsetUtil.US_ASCII));
        ByteArrayInputStream keyStream = new ByteArrayInputStream(pem.getBytes(CharsetUtil.US_ASCII));
        SslContext context = SslContextBuilder.forServer((InputStream)certStream, (InputStream)keyStream, null).sslProvider(provider).clientAuth(ClientAuth.OPTIONAL).build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertTrue((boolean)engine.getWantClientAuth());
        Assertions.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    @Test
    public void testInvalidCipherJdk() throws Exception {
        OpenSsl.ensureAvailability();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContextBuilderTest.testInvalidCipher(SslProvider.JDK);
            }
        });
    }

    @Test
    public void testInvalidCipherOpenSSL() throws Exception {
        OpenSsl.ensureAvailability();
        try {
            SslContextBuilderTest.testInvalidCipher(SslProvider.OPENSSL);
            if (!OpenSsl.versionString().contains("1.1.1")) {
                Assertions.fail();
            }
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private static void testKeyStoreType(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(provider).keyStoreType("PKCS12");
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testInvalidCipher(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).ciphers(Collections.singleton("SOME_INVALID_CIPHER")).keyManager(cert.certificate(), cert.privateKey()).trustManager(cert.certificate());
        SslContext context = builder.build();
        context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    private static void testClientContextFromFile(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).keyManager(cert.certificate(), cert.privateKey()).trustManager(cert.certificate()).clientAuth(ClientAuth.OPTIONAL);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)engine.getWantClientAuth());
        Assertions.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testClientContext(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).keyManager(cert.key(), new X509Certificate[]{cert.cert()}).trustManager(new X509Certificate[]{cert.cert()}).clientAuth(ClientAuth.OPTIONAL);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)engine.getWantClientAuth());
        Assertions.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testServerContextFromFile(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(provider).trustManager(cert.certificate()).clientAuth(ClientAuth.OPTIONAL);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertTrue((boolean)engine.getWantClientAuth());
        Assertions.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testServerContext(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).trustManager(new X509Certificate[]{cert.cert()}).clientAuth(ClientAuth.REQUIRE);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)engine.getWantClientAuth());
        Assertions.assertTrue((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testContextFromManagers(SslProvider provider) throws Exception {
        final SelfSignedCertificate cert = new SelfSignedCertificate();
        X509ExtendedKeyManager customKeyManager = new X509ExtendedKeyManager(){

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                return new String[0];
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                return "cert_sent_to_server";
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return new String[0];
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String s) {
                X509Certificate[] certificates = new X509Certificate[]{cert.cert()};
                return new X509Certificate[0];
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return cert.key();
            }
        };
        X509ExtendedTrustManager customTrustManager = new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SslContextBuilder client_builder = SslContextBuilder.forClient().sslProvider(provider).keyManager((KeyManager)customKeyManager).trustManager((TrustManager)customTrustManager).clientAuth(ClientAuth.OPTIONAL);
        SslContext client_context = client_builder.build();
        SSLEngine client_engine = client_context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)client_engine.getWantClientAuth());
        Assertions.assertFalse((boolean)client_engine.getNeedClientAuth());
        client_engine.closeInbound();
        client_engine.closeOutbound();
        SslContextBuilder server_builder = SslContextBuilder.forServer((KeyManager)customKeyManager).sslProvider(provider).trustManager((TrustManager)customTrustManager).clientAuth(ClientAuth.REQUIRE);
        SslContext server_context = server_builder.build();
        SSLEngine server_engine = server_context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertFalse((boolean)server_engine.getWantClientAuth());
        Assertions.assertTrue((boolean)server_engine.getNeedClientAuth());
        server_engine.closeInbound();
        server_engine.closeOutbound();
    }
}

