/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.SignatureAlgorithmConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SignatureAlgorithmConverterTest {
    @Test
    public void testWithEncryption() {
        Assertions.assertEquals((Object)"SHA512withRSA", (Object)SignatureAlgorithmConverter.toJavaName((String)"sha512WithRSAEncryption"));
    }

    @Test
    public void testWithDash() {
        Assertions.assertEquals((Object)"SHA256withECDSA", (Object)SignatureAlgorithmConverter.toJavaName((String)"ecdsa-with-SHA256"));
    }

    @Test
    public void testWithUnderscore() {
        Assertions.assertEquals((Object)"SHA256withDSA", (Object)SignatureAlgorithmConverter.toJavaName((String)"dsa_with_SHA256"));
    }

    @Test
    public void testBoringSSLOneUnderscore() {
        Assertions.assertEquals((Object)"SHA256withECDSA", (Object)SignatureAlgorithmConverter.toJavaName((String)"ecdsa_sha256"));
    }

    @Test
    public void testBoringSSLPkcs1() {
        Assertions.assertEquals((Object)"SHA256withRSA", (Object)SignatureAlgorithmConverter.toJavaName((String)"rsa_pkcs1_sha256"));
    }

    @Test
    public void testBoringSSLPSS() {
        Assertions.assertEquals((Object)"SHA256withRSA", (Object)SignatureAlgorithmConverter.toJavaName((String)"rsa_pss_rsae_sha256"));
    }

    @Test
    public void testInvalid() {
        Assertions.assertNull((Object)SignatureAlgorithmConverter.toJavaName((String)"ThisIsSomethingInvalid"));
    }
}

