/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSslEngineTest;
import io.netty.handler.ssl.OpenSslEngineTestParam;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import javax.net.ssl.SSLEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ReferenceCountedOpenSslEngineTest
extends OpenSslEngineTest {
    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.OPENSSL_REFCNT;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL_REFCNT;
    }

    @Override
    protected void cleanupClientSslContext(SslContext ctx) {
        ReferenceCountUtil.release((Object)ctx);
    }

    @Override
    protected void cleanupClientSslEngine(SSLEngine engine) {
        ReferenceCountUtil.release((Object)this.unwrapEngine(engine));
    }

    @Override
    protected void cleanupServerSslContext(SslContext ctx) {
        ReferenceCountUtil.release((Object)ctx);
    }

    @Override
    protected void cleanupServerSslEngine(SSLEngine engine) {
        ReferenceCountUtil.release((Object)this.unwrapEngine(engine));
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testNotLeakOnException(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ReferenceCountedOpenSslEngineTest.this.clientSslCtx.newEngine(null);
            }
        });
    }

    @Override
    protected SslContext wrapContext(SSLEngineTest.SSLEngineTestParam param, SslContext context) {
        if (context instanceof ReferenceCountedOpenSslContext) {
            if (param instanceof OpenSslEngineTestParam) {
                ((ReferenceCountedOpenSslContext)context).setUseTasks(((OpenSslEngineTestParam)param).useTasks);
            }
            ((ReferenceCountedOpenSslContext)context).sessionContext().setSessionCacheEnabled(true);
        }
        return context;
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void parentContextIsRetainedByChildEngines(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        SslContext clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine engine = clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assertions.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)2);
        this.cleanupClientSslContext(clientSslCtx);
        Assertions.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)1);
        this.cleanupClientSslEngine(engine);
        Assertions.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)0);
    }
}

