/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslPrivateKey;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.internal.tcnative.SSL;
import io.netty.util.ReferenceCountUtil;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class OpenSslKeyMaterialProviderTest {
    static final String PASSWORD = "example";
    static final String EXISTING_ALIAS = "1";
    private static final String NON_EXISTING_ALIAS = "nonexisting";

    @BeforeAll
    static void checkOpenSsl() {
        OpenSsl.ensureAvailability();
    }

    protected KeyManagerFactory newKeyManagerFactory() throws Exception {
        return this.newKeyManagerFactory(KeyManagerFactory.getDefaultAlgorithm());
    }

    protected KeyManagerFactory newKeyManagerFactory(String algorithm) throws Exception {
        char[] password = PASSWORD.toCharArray();
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        keystore.load(this.getClass().getResourceAsStream("mutual_auth_server.p12"), password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(keystore, password);
        return kmf;
    }

    protected OpenSslKeyMaterialProvider newMaterialProvider(KeyManagerFactory factory, String password) {
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager((KeyManager[])factory.getKeyManagers()), password);
    }

    protected void assertRelease(OpenSslKeyMaterial material) {
        Assertions.assertTrue((boolean)material.release());
    }

    @Test
    public void testChooseKeyMaterial() throws Exception {
        OpenSslKeyMaterialProvider provider = this.newMaterialProvider(this.newKeyManagerFactory(), PASSWORD);
        OpenSslKeyMaterial nonExistingMaterial = provider.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, NON_EXISTING_ALIAS);
        Assertions.assertNull((Object)nonExistingMaterial);
        OpenSslKeyMaterial material = provider.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, EXISTING_ALIAS);
        Assertions.assertNotNull((Object)material);
        Assertions.assertNotEquals((long)0L, (long)material.certificateChainAddress());
        Assertions.assertNotEquals((long)0L, (long)material.privateKeyAddress());
        this.assertRelease(material);
        provider.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseOpenSslPrivateKeyMaterial() throws Exception {
        OpenSslPrivateKey sslPrivateKey;
        PrivateKey privateKey = SslContext.toPrivateKey((InputStream)this.getClass().getResourceAsStream("localhost_server.key"), null);
        Assertions.assertNotNull((Object)privateKey);
        Assertions.assertEquals((Object)"PKCS#8", (Object)privateKey.getFormat());
        X509Certificate[] certChain = SslContext.toX509Certificates((InputStream)this.getClass().getResourceAsStream("localhost_server.pem"));
        Assertions.assertNotNull((Object)certChain);
        PemEncoded pemKey = null;
        long pkeyBio = 0L;
        try {
            pemKey = PemPrivateKey.toPEM((ByteBufAllocator)ByteBufAllocator.DEFAULT, (boolean)true, (PrivateKey)privateKey);
            pkeyBio = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)ByteBufAllocator.DEFAULT, (PemEncoded)pemKey.retain());
            sslPrivateKey = new OpenSslPrivateKey(SSL.parsePrivateKey((long)pkeyBio, null));
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.safeRelease(pemKey);
            if (pkeyBio != 0L) {
                SSL.freeBIO((long)pkeyBio);
            }
            throw throwable;
        }
        ReferenceCountUtil.safeRelease((Object)pemKey);
        if (pkeyBio != 0L) {
            SSL.freeBIO((long)pkeyBio);
        }
        String keyAlias = "key";
        OpenSslKeyMaterialProvider provider = new OpenSslKeyMaterialProvider((X509KeyManager)new SingleKeyManager("key", (PrivateKey)sslPrivateKey, certChain), null);
        OpenSslKeyMaterial material = provider.chooseKeyMaterial(ByteBufAllocator.DEFAULT, "key");
        Assertions.assertNotNull((Object)material);
        Assertions.assertEquals((int)2, (int)sslPrivateKey.refCnt());
        Assertions.assertEquals((int)1, (int)material.refCnt());
        Assertions.assertTrue((boolean)material.release());
        Assertions.assertEquals((int)1, (int)sslPrivateKey.refCnt());
        material = provider.chooseKeyMaterial(ByteBufAllocator.DEFAULT, "key");
        Assertions.assertNotNull((Object)material);
        Assertions.assertEquals((int)2, (int)sslPrivateKey.refCnt());
        Assertions.assertTrue((boolean)material.release());
        Assertions.assertTrue((boolean)sslPrivateKey.release());
        Assertions.assertEquals((int)0, (int)sslPrivateKey.refCnt());
        Assertions.assertEquals((int)0, (int)material.refCnt());
        Assertions.assertEquals((long)0L, (long)((OpenSslPrivateKey.OpenSslPrivateKeyMaterial)material).certificateChain);
    }

    private static final class SingleKeyManager
    implements X509KeyManager {
        private final String keyAlias;
        private final PrivateKey pk;
        private final X509Certificate[] certChain;

        SingleKeyManager(String keyAlias, PrivateKey pk, X509Certificate[] certChain) {
            this.keyAlias = keyAlias;
            this.pk = pk;
            this.certChain = certChain;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{this.keyAlias};
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyAlias;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return new String[]{this.keyAlias};
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.keyAlias;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.certChain;
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.pk;
        }
    }
}

