/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ConscryptSslEngineTest;
import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngineTestParam;
import io.netty.handler.ssl.OpenSslTestUtils;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import java.security.Provider;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@DisabledIf(value="checkConscryptDisabled")
public class ConscryptOpenSslEngineInteropTest
extends ConscryptSslEngineTest {
    @Override
    protected List<SSLEngineTest.SSLEngineTestParam> newTestParams() {
        List<SSLEngineTest.SSLEngineTestParam> params = super.newTestParams();
        ArrayList<SSLEngineTest.SSLEngineTestParam> testParams = new ArrayList<SSLEngineTest.SSLEngineTestParam>();
        for (SSLEngineTest.SSLEngineTestParam param : params) {
            testParams.add(new OpenSslEngineTestParam(true, param));
            testParams.add(new OpenSslEngineTestParam(false, param));
        }
        return testParams;
    }

    @BeforeAll
    public static void checkOpenssl() {
        OpenSsl.ensureAvailability();
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL;
    }

    @Override
    protected Provider serverSslContextProvider() {
        return null;
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="TODO: Make this work with Conscrypt")
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) {
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="TODO: Make this work with Conscrypt")
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) {
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(param);
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidClientException(cause) || ConscryptOpenSslEngineInteropTest.causedBySSLException(cause);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeKeyManagerFactory(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactory(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactoryMutualAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSupportedSignatureAlgorithms(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSupportedSignatureAlgorithms(param);
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidServerException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidServerException(cause) || ConscryptOpenSslEngineInteropTest.causedBySSLException(cause);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithKeyManager(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionLocalWhenNonMutualWithKeyManager(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithoutKeyManager(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.supportsKeyManagerFactory());
        super.testSessionLocalWhenNonMutualWithoutKeyManager(param);
    }

    @Override
    protected void invalidateSessionsAndAssert(SSLSessionContext context) {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCache(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCache(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheTimeout(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCacheTimeout(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheSize(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCacheSize(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disabled due a conscrypt bug")
    public void testInvalidSNIIsIgnoredAndNotThrow(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testInvalidSNIIsIgnoredAndNotThrow(param);
    }

    @Override
    @Test
    @Disabled(value="Disabled due a conscrypt bug")
    public void testTLSv13DisabledIfNoValidCipherSuiteConfigured() throws Exception {
        super.testTLSv13DisabledIfNoValidCipherSuiteConfigured();
    }

    @Override
    protected SSLEngine wrapEngine(SSLEngine engine) {
        return Java8SslTestUtils.wrapSSLEngineForTesting(engine);
    }

    @Override
    protected SslContext wrapContext(SSLEngineTest.SSLEngineTestParam param, SslContext context) {
        if (context instanceof OpenSslContext) {
            if (param instanceof OpenSslEngineTestParam) {
                ((OpenSslContext)context).setUseTasks(((OpenSslEngineTestParam)param).useTasks);
            }
            ((OpenSslContext)context).sessionContext().setSessionCacheEnabled(true);
        }
        return context;
    }
}

